/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.csv;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class CsvFieldMapping {
    private boolean manualMapping;

    public abstract boolean isNewCustomField();

    public abstract boolean isExistingCustomField();

    public abstract boolean isJiraField();

    public abstract boolean isLinking();

    public abstract Long getLinkTypeId();

    public abstract String getJiraFieldName();

    public abstract Long getCustomFieldId();

    public abstract String getCustomFieldName();

    public abstract String getCustomFieldType();

    public abstract String getCustomFieldSearcher();

    public abstract void toConfig(Map<String, String> var1);

    public Map<String, String> toConfig() {
        HashMap config = Maps.newHashMap();
        this.toConfig(config);
        return config;
    }

    public boolean isManualMapping() {
        return this.manualMapping;
    }

    public void setManualMapping(boolean manualMapping) {
        this.manualMapping = manualMapping;
    }

    public static CsvFieldMapping field(String field) {
        return new FieldMapping(field);
    }

    public static CsvFieldMapping existingCF(String id) {
        return new ExistingCFMapping(Long.parseLong(id));
    }

    public static CsvFieldMapping existingCF(Long id) {
        return new ExistingCFMapping(id);
    }

    public static CsvFieldMapping newCF(String name, String type, String searcher) {
        return new NewCFMapping(name, type, searcher);
    }

    public static CsvFieldMapping link(Long linkId) {
        return new LinkingMapping(linkId);
    }

    public static CsvFieldMapping fromConfig(Map<String, String> config) throws IllegalStateException {
        if (config.containsKey("jira.field")) {
            return new FieldMapping(config.get("jira.field"));
        }
        if (config.containsKey("existing.custom.field")) {
            Long idFromConfig = Long.valueOf(config.get("existing.custom.field"));
            return new ExistingCFMapping(idFromConfig);
        }
        if (config.containsKey("new.custom.field.name") && config.containsKey("new.custom.field.type") && config.containsKey("new.custom.field.searcher")) {
            String cfName = config.get("new.custom.field.name");
            String cfType = config.get("new.custom.field.type");
            String cfSearcher = config.get("new.custom.field.searcher");
            return new NewCFMapping(cfName, cfType, cfSearcher);
        }
        if (config.containsKey("link.type")) {
            Long idFromConfig = Long.valueOf(config.get("link.type"));
            return new LinkingMapping(idFromConfig);
        }
        throw new IllegalArgumentException("Cannot read field mapping config");
    }

    private static class LinkingMapping
    extends CsvFieldMapping {
        private final Long linkTypeId;

        private LinkingMapping(Long linkTypeId) {
            this.linkTypeId = linkTypeId;
        }

        @Override
        public boolean isNewCustomField() {
            return false;
        }

        @Override
        public boolean isExistingCustomField() {
            return false;
        }

        @Override
        public boolean isJiraField() {
            return false;
        }

        @Override
        public boolean isLinking() {
            return true;
        }

        @Override
        public Long getLinkTypeId() {
            return this.linkTypeId;
        }

        @Override
        public String getJiraFieldName() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public Long getCustomFieldId() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldName() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldType() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldSearcher() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public void toConfig(Map<String, String> config) {
            config.put("link.type", "" + this.linkTypeId);
        }
    }

    private static class NewCFMapping
    extends CsvFieldMapping {
        private final String name;
        private final String type;
        private final String searcher;

        private NewCFMapping(String name, String type, String searcher) {
            this.name = name;
            this.type = type;
            this.searcher = searcher;
        }

        @Override
        public boolean isNewCustomField() {
            return true;
        }

        @Override
        public boolean isExistingCustomField() {
            return false;
        }

        @Override
        public boolean isJiraField() {
            return false;
        }

        @Override
        public boolean isLinking() {
            return false;
        }

        @Override
        public Long getLinkTypeId() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getJiraFieldName() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public Long getCustomFieldId() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldName() {
            return this.name;
        }

        @Override
        public String getCustomFieldType() {
            return this.type;
        }

        @Override
        public String getCustomFieldSearcher() {
            return this.searcher;
        }

        @Override
        public void toConfig(Map<String, String> config) {
            config.put("new.custom.field.name", this.name);
            config.put("new.custom.field.type", this.type);
            config.put("new.custom.field.searcher", this.searcher);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.searcher);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NewCFMapping that = (NewCFMapping)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.searcher, that.searcher);
        }
    }

    private static class ExistingCFMapping
    extends CsvFieldMapping {
        private final Long id;

        private ExistingCFMapping(Long id) {
            this.id = id;
        }

        @Override
        public boolean isNewCustomField() {
            return false;
        }

        @Override
        public boolean isExistingCustomField() {
            return true;
        }

        @Override
        public boolean isJiraField() {
            return false;
        }

        @Override
        public boolean isLinking() {
            return false;
        }

        @Override
        public Long getLinkTypeId() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getJiraFieldName() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public Long getCustomFieldId() {
            return this.id;
        }

        @Override
        public String getCustomFieldName() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldType() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldSearcher() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public void toConfig(Map<String, String> config) {
            config.put("existing.custom.field", "" + this.id);
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExistingCFMapping that = (ExistingCFMapping)o;
            return Objects.equals(this.id, that.id);
        }
    }

    private static class FieldMapping
    extends CsvFieldMapping {
        private final String jiraField;

        private FieldMapping(String jiraField) {
            this.jiraField = jiraField;
        }

        @Override
        public boolean isNewCustomField() {
            return false;
        }

        @Override
        public boolean isExistingCustomField() {
            return false;
        }

        @Override
        public boolean isJiraField() {
            return true;
        }

        @Override
        public boolean isLinking() {
            return false;
        }

        @Override
        public Long getLinkTypeId() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getJiraFieldName() {
            return this.jiraField;
        }

        @Override
        public Long getCustomFieldId() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldName() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldType() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public String getCustomFieldSearcher() {
            throw new IllegalStateException("It's not that kind of field");
        }

        @Override
        public void toConfig(Map<String, String> config) {
            config.put("jira.field", this.jiraField);
        }
    }
}

