/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.csv;

import com.atlassian.fugue.Pair;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import webwork.action.ActionContext;

public abstract class AbstractCsvValueMappingPage
extends ImporterProcessSupport {
    private static final String VALUE_MAPPING_PREFIX = "value.";
    protected final ConstantsManager constantsManager;
    protected final CustomFieldManager customFieldManager;
    protected final IssueLinkTypeManager issueLinkTypeManager;

    public AbstractCsvValueMappingPage(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor, @ComponentImport ConstantsManager constantsManager, @ComponentImport CustomFieldManager customFieldManager, IssueLinkTypeManager issueLinkTypeManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    public GoodCsvConfigBean getConfigBean() {
        return (GoodCsvConfigBean)this.getController().getImportProcessBeanFromSession().getConfigBean();
    }

    public boolean doesConstantExistByNameOrId(Collection<? extends IssueConstant> collection, final @Nullable String nameOrId) {
        return nameOrId != null && Iterables.any(collection, (Predicate)new Predicate<IssueConstant>(){

            public boolean apply(@Nullable IssueConstant input) {
                return input != null && (nameOrId.equalsIgnoreCase(input.getName()) || nameOrId.equalsIgnoreCase(input.getNameTranslation()) || nameOrId.equalsIgnoreCase(input.getId()));
            }
        });
    }

    public Collection<IssueType> getIssueTypes() {
        return this.constantsManager.getAllIssueTypeObjects();
    }

    public Collection<Priority> getPriorities() {
        return this.constantsManager.getPriorityObjects();
    }

    @Override
    @RequiresXsrfCheck
    protected void doValidation() {
        super.doValidation();
        GoodCsvConfigBean configBean = this.getConfigBean();
        if (configBean == null) {
            return;
        }
        Map params = ActionContext.getParameters();
        Iterable valueMappingsParams = Iterables.filter(params.entrySet(), (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return input.getKey() != null && input.getKey().startsWith(AbstractCsvValueMappingPage.VALUE_MAPPING_PREFIX);
            }
        });
        configBean.cleanValueMappings();
        for (Map.Entry param : valueMappingsParams) {
            Integer id;
            String valueId = ((String)param.getKey()).replace(VALUE_MAPPING_PREFIX, "");
            try {
                id = Integer.valueOf(valueId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            Pair<String, String> headerAndCsvValue = configBean.getHeaderAndCsvValueForId(id);
            configBean.putNewValueMapping((String)headerAndCsvValue.left(), (String)headerAndCsvValue.right(), this.normalizeParamValue(param.getValue()));
        }
    }

    private String normalizeParamValue(Object value) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            Object item = array.length > 0 ? array[0] : value;
            return item != null ? item.toString() : null;
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public List<String> getHeadersForValueMapping() {
        return ImmutableList.copyOf(this.getConfigBean().getHeadersForManualMapping());
    }

    public String getJiraFieldNameFor(String header) {
        Optional<CsvFieldMapping> possibleMapping = this.getConfigBean().getMappingFor(header);
        if (possibleMapping.isPresent()) {
            CustomField customField;
            CsvFieldMapping mapping = (CsvFieldMapping)possibleMapping.get();
            if (mapping.isJiraField()) {
                return mapping.getJiraFieldName();
            }
            if (mapping.isLinking()) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(mapping.getLinkTypeId());
                return String.format("Link \"%s\"", issueLinkType.getName());
            }
            String customFieldName = mapping.isExistingCustomField() ? ((customField = this.customFieldManager.getCustomFieldObject(mapping.getCustomFieldId())) != null ? customField.getFieldName() : "(?)") : mapping.getCustomFieldName();
            return String.format("Custom Field %s", customFieldName);
        }
        return "(?)";
    }

    public int getUniqueValuesCountForHeader(String header) {
        return this.getUniqueValuesFor(header).size();
    }

    public List<String> getUniqueValuesFor(String header) {
        ServiceOutcome<Multimap<String, String>> uniqueValues = this.getConfigBean().getUniqueValues();
        if (uniqueValues.isValid()) {
            ArrayList uniqueStrings = Lists.newArrayList((Iterable)((Multimap)uniqueValues.get()).get((Object)header));
            Collections.sort(uniqueStrings);
            return uniqueStrings;
        }
        return ImmutableList.of();
    }

    public String getMappedValueFor(String header, String csvValue) {
        return this.getConfigBean().getValueMappingForHeader(header, csvValue);
    }

    public String getTextboxUniqueName(String header, String csvValue) {
        return VALUE_MAPPING_PREFIX + this.getConfigBean().getMappedValueUniqueName(header, csvValue);
    }

    public boolean isMappedAsBlank(String header, String csvValue) {
        return "<<blank>>".equals(this.getMappedValueFor(header, csvValue));
    }

    public boolean isIssueConstantMappingSelected(IssueConstant constant, String header, String csvValue) {
        String mappedValue = this.getConfigBean().getValueMappingForHeader(header, csvValue);
        return constant != null && (constant.getId().equals(mappedValue) || constant.getName().equals(mappedValue) || constant.getNameTranslation().equals(mappedValue));
    }
}

