/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.csv;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.plugins.importer.web.components.ProjectModel;
import com.atlassian.jira.plugins.importer.web.components.ProjectSelectionModel;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractCsvProjectMappingPage
extends ImporterProcessSupport {
    protected final ProjectManager projectManager;
    protected ImporterProjectMappingsPage.Helper helper;

    public AbstractCsvProjectMappingPage(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor, @ComponentImport ProjectService projectService, @ComponentImport ProjectManager projectManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.helper = new ImporterProjectMappingsPage.Helper(projectService, this.getLoggedInApplicationUser());
        this.projectManager = projectManager;
    }

    public Collection<ExternalProject> getSuggestedNewProjects() {
        GoodCsvConfigBean configBean = this.getConfigBean();
        if (configBean.getPickedProject() == null) {
            return Collections.emptyList();
        }
        ArrayList suggestedKeys = Lists.newArrayList((Object[])new ExternalProject[]{configBean.getPickedProject()});
        final Set<String> existingProjectKeys = this.helper.getExistingProjectKeys();
        return Collections2.filter((Collection)suggestedKeys, (Predicate)new Predicate<ExternalProject>(){

            public boolean apply(ExternalProject suggestedProject) {
                String key = suggestedProject.getKey();
                return StringUtils.isNotBlank((String)key) && !existingProjectKeys.contains(key);
            }
        });
    }

    public String getProjectMappingModel() {
        ProjectSelectionModel model = new ProjectSelectionModel();
        GoodCsvConfigBean configBean = this.getConfigBean();
        ExternalProject pickedProject = configBean.getPickedProject();
        model.key = pickedProject != null ? pickedProject.getKey() : null;
        model.selected = !configBean.isReadingProjectFromCsv();
        model.type = pickedProject != null ? pickedProject.getType() : null;
        model.id = "CSV";
        try {
            return new ObjectMapper().writeValueAsString((Object)model);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getProjectSuggestionsModel() {
        ArrayList suggestions = Lists.newArrayList((Iterable)Iterables.transform(this.getApplicableProjects(), (Function)new Function<Project, ProjectModel>(){

            public ProjectModel apply(Project input) {
                return new ProjectModel(input.getId(), input.getName(), input.getKey());
            }
        }));
        suggestions.addAll(Collections2.transform(this.getSuggestedNewProjects(), ProjectModel.fromExternalProject()));
        try {
            return new ObjectMapper().writeValueAsString((Object)suggestions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Collection<Project> getApplicableProjects();

    public GoodCsvConfigBean getConfigBean() {
        return (GoodCsvConfigBean)this.getController().getImportProcessBeanFromSession().getConfigBean();
    }
}

