/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.csv;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.plugins.importer.web.components.CustomFieldModel;
import com.atlassian.jira.plugins.importer.web.components.FieldMapping;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.TypeReference;

public abstract class AbstractCsvFieldMappingPage
extends ImporterProcessSupport {
    private static final int MAXIMUM_MAP_VALUES = 9000;
    protected final CustomFieldManager customFieldManager;
    protected final EventPublisher eventPublisher;
    protected String model;

    public AbstractCsvFieldMappingPage(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor, @ComponentImport CustomFieldManager customFieldManager, EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.customFieldManager = customFieldManager;
        this.eventPublisher = eventPublisher;
    }

    public static String getFieldName(String fieldName) {
        return "field-" + DigestUtils.md5Hex((String)fieldName);
    }

    public GoodCsvConfigBean getConfigBean() {
        ImporterController controller = this.getController();
        return controller != null ? (GoodCsvConfigBean)controller.getImportProcessBeanFromSession().getConfigBean() : null;
    }

    @Override
    @RequiresXsrfCheck
    protected void doValidation() {
        ServiceOutcome<Multimap<String, String>> mappedValues;
        super.doValidation();
        if (!this.isNextClicked()) {
            return;
        }
        GoodCsvConfigBean configBean = this.getConfigBean();
        if (configBean == null) {
            return;
        }
        Collection<FieldMapping> mappings = this.parseMappingsFromModel();
        final ImmutableMap mappingsMap = Maps.uniqueIndex(mappings, (Function)new Function<FieldMapping, String>(){

            public String apply(FieldMapping input) {
                return input.id;
            }
        });
        Iterable parsedMappings = Iterables.filter((Iterable)Iterables.transform(configBean.getHeader(), (Function)new Function<String, Pair<String, CsvFieldMapping>>(){

            public Pair<String, CsvFieldMapping> apply(@Nullable String header) {
                CsvFieldMapping result;
                FieldMapping mapping = (FieldMapping)mappingsMap.get((Object)AbstractCsvFieldMappingPage.getFieldName(header));
                if (mapping == null || !mapping.imported) {
                    return null;
                }
                CustomFieldModel cfModel = mapping.customFieldModel;
                if (cfModel != null) {
                    result = StringUtils.isNotBlank((String)cfModel.id) ? CsvFieldMapping.existingCF(cfModel.id.replace("customfield_", "")) : CsvFieldMapping.newCF(cfModel.name, cfModel.type, null);
                } else if (mapping.targetField.startsWith("link-")) {
                    String linkIdString = mapping.targetField.replace("link-", "");
                    Long linkId = Long.valueOf(linkIdString);
                    result = CsvFieldMapping.link(linkId);
                } else {
                    result = CsvFieldMapping.field(mapping.targetField);
                }
                result.setManualMapping(mapping.manualMapping);
                return Pair.pair((Object)header, (Object)result);
            }
        }), (Predicate)Predicates.notNull());
        configBean.putFieldMappings((ImmutableList<Pair<String, CsvFieldMapping>>)ImmutableList.copyOf((Iterable)parsedMappings));
        if (!configBean.isAnyHeaderMappedTo("summary")) {
            this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mappings.page.must.have.summary"));
        }
        if ((mappedValues = configBean.getUniqueValues()).isValid()) {
            int mapValuesCount = 0;
            Multimap uniqueValues = (Multimap)mappedValues.get();
            for (String header : configBean.getHeadersForManualMapping()) {
                mapValuesCount += uniqueValues.get((Object)header).size();
            }
            if (mapValuesCount > 9000) {
                this.addErrorMessage(this.getText("jira-importer-plugin.csv.field.mapping.page.too.many.mappings.values"));
            }
        } else {
            this.addErrorMessages(mappedValues.getErrorCollection().getErrorMessages());
        }
    }

    private Collection<FieldMapping> parseMappingsFromModel() {
        Collection mappings;
        try {
            mappings = (Collection)new ObjectMapper().readValue(this.model, (TypeReference)new TypeReference<Collection<FieldMapping>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mappings;
    }

    public abstract ImmutableSet<CustomField> getCustomFields();

    public String getCustomFieldsModel() {
        ImmutableSet<CustomField> customFields = this.getCustomFields();
        Iterable model = Iterables.transform(customFields, (Function)new Function<CustomField, CustomFieldModel>(){

            public CustomFieldModel apply(CustomField input) {
                CustomFieldModel model = new CustomFieldModel();
                model.id = input.getId();
                model.name = input.getName();
                return model;
            }
        });
        try {
            return new ObjectMapper().configure(SerializationConfig.Feature.INDENT_OUTPUT, true).writeValueAsString((Object)ImmutableList.copyOf((Iterable)model));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String doExecute() throws Exception {
        if (this.isNextClicked() && !this.getHasErrors()) {
            this.publishCsvEvent();
        }
        return super.doExecute();
    }

    private void publishCsvEvent() {
    }

    public Collection<FieldMapping> getModelImpl() {
        GoodCsvConfigBean configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        final Map<String, CsvFieldMapping> fieldMappings = configBean.getFieldMappings();
        return ImmutableList.copyOf((Iterable)Iterables.transform(configBean.getHeader(), (Function)new Function<String, FieldMapping>(){

            public FieldMapping apply(String header) {
                CsvFieldMapping mapping = (CsvFieldMapping)fieldMappings.get(header);
                String id = AbstractCsvFieldMappingPage.getFieldName(header);
                if (mapping != null) {
                    if (mapping.isJiraField()) {
                        return new FieldMapping(id, true, mapping.getJiraFieldName(), mapping.isManualMapping());
                    }
                    if (mapping.isExistingCustomField()) {
                        return new FieldMapping(id, true, "customfield_" + mapping.getCustomFieldId(), mapping.isManualMapping());
                    }
                    if (mapping.isLinking()) {
                        return new FieldMapping(id, true, "link-" + mapping.getLinkTypeId(), mapping.isManualMapping());
                    }
                    FieldMapping field = new FieldMapping(AbstractCsvFieldMappingPage.getFieldName(header), true, "newCustomField", mapping.isManualMapping());
                    field.customFieldModel = new CustomFieldModel();
                    field.customFieldModel.name = mapping.getCustomFieldName();
                    field.customFieldModel.type = mapping.getCustomFieldType();
                    return field;
                }
                return new FieldMapping(id, false, null, false);
            }
        }));
    }

    public String getModel() {
        try {
            return new ObjectMapper().configure(SerializationConfig.Feature.INDENT_OUTPUT, true).writeValueAsString(this.getModelImpl());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setModel(String model) {
        this.model = model;
    }

    public boolean hasAtLeastOneEmptyHeader() {
        return Iterables.any((Iterable)Lists.newArrayList((Object[])this.getConfigBean().getRawHeader()), (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return StringUtils.isBlank((String)input);
            }
        });
    }

    public String getSampleDataForHeader(String header) {
        return this.getConfigBean().getSampleDataFor(header);
    }

    public Map<String, Map<String, String>> getFieldMappingsFor(String header) {
        if (this.getConfigBean().hasHeaderMultipleColumns(header)) {
            return this.getMappingsForMultiple();
        }
        return this.getMappingsForSingle();
    }

    protected abstract Map<String, Map<String, String>> getMappingsForSingle();

    protected abstract Map<String, Map<String, String>> getMappingsForMultiple();

    public Map<String, String> getUnmappedFields() {
        final GoodCsvConfigBean configBean = this.getConfigBean();
        Map<String, CsvFieldMapping> mappings = configBean.getFieldMappings();
        Iterable unmapped = Iterables.filter(mappings.entrySet(), (Predicate)new Predicate<Map.Entry<String, CsvFieldMapping>>(){

            public boolean apply(Map.Entry<String, CsvFieldMapping> input) {
                return !configBean.getHeader().contains(input.getKey());
            }
        });
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : unmapped) {
            CsvFieldMapping value = (CsvFieldMapping)entry.getValue();
            if (value.isJiraField()) {
                map.put(entry.getKey(), value.getJiraFieldName());
                continue;
            }
            if (value.isExistingCustomField()) {
                map.put(entry.getKey(), this.getI18nHelper().getText("jira-importer-plugin.csv.unmapped.field.existing.cf", (Object)value.getCustomFieldId()));
                continue;
            }
            if (value.isNewCustomField()) {
                map.put(entry.getKey(), this.getI18nHelper().getText("jira-importer-plugin.csv.unmapped.field.new.cf", value.getCustomFieldName(), value.getCustomFieldType()));
                continue;
            }
            map.put(entry.getKey(), this.getI18nHelper().getText("jira-importer-plugin.csv.unmapped.field.link", (Object)value.getLinkTypeId()));
        }
        return map;
    }

    public boolean isValueSelected(String header, String value) {
        Optional<CsvFieldMapping> mapping = this.getConfigBean().getMappingFor(header);
        return mapping.isPresent() && ((CsvFieldMapping)mapping.get()).isJiraField() && ((CsvFieldMapping)mapping.get()).getJiraFieldName().equals(value);
    }
}

