/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

public final class TextsUtil {
    public static ResourceBundle getTexts(JiraWebActionSupport as, String bundleName) {
        try {
            return as.getTexts(bundleName);
        }
        catch (MissingResourceException e) {
            if (bundleName.startsWith("com.atlassian.jira.plugins.importer")) {
                return ResourceBundle.getBundle("com.atlassian.jira.plugins.importer.web.action.util.messages", as.getLocale(), as.getClass().getClassLoader());
            }
            throw e;
        }
    }

    public static String convertToNiceHtmlString(String str) {
        Iterable splitStr = Splitter.on((String)"\n").split((CharSequence)str);
        return TextsUtil.convertToNiceHtmlString(splitStr);
    }

    public static String convertToNiceHtmlString(Iterable<String> splitStr) {
        if (Iterables.size(splitStr) <= 1) {
            return (String)Iterables.getFirst(splitStr, (Object)"");
        }
        StringBuilder res = new StringBuilder();
        for (String line : splitStr) {
            res.append("<p>").append(line).append("</p>");
        }
        return res.toString();
    }

    public static String buildErrorMessage(ErrorCollection errorCollection) {
        String msg1 = StringUtils.join((Collection)errorCollection.getErrorMessages(), (String)"\n");
        ArrayList sortedKeys = Lists.newArrayList(errorCollection.getErrors().keySet());
        Collections.sort(sortedKeys);
        ArrayList sortedValues = Lists.newArrayListWithCapacity((int)sortedKeys.size());
        for (String key : sortedKeys) {
            sortedValues.add(errorCollection.getErrors().get(key));
        }
        String msg2 = StringUtils.join((Collection)sortedValues, (String)"\n");
        return msg1 + (!StringUtils.isEmpty((String)msg1) && !StringUtils.isEmpty((String)msg2) ? "\n" : "") + msg2;
    }
}

