/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.compatibility.UserAccessGrantingResult;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.plugins.importer.web.UserAccessBean;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@WebSudoNotRequired
public class ImporterUserAccessPage
extends ImporterProcessSupport {
    private static final String OPTION_DO_NOTHING = "option-1";
    private static final String OPTION_GIVE_ACCESS = "option-2";
    private static final String USER_ACCESS_LOCATION = "jim.webpanels.after.user.access.picker";
    private final CompatibilityBridgeUtils bridgeUtils;
    private String[] selectedApplications = new String[0];
    private String selectedOption = null;

    public ImporterUserAccessPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, CompatibilityBridgeUtils bridgeUtils) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.bridgeUtils = bridgeUtils;
    }

    public void setSelectedApplications(String[] selectedApplications) {
        this.selectedApplications = selectedApplications;
    }

    public void setSelectedOption(String selectedOption) {
        this.selectedOption = selectedOption;
    }

    @Override
    @Nullable
    public String getFormTitle() {
        return null;
    }

    public String getFromHeader() {
        return this.getI18nHelper().getText("jira-importer-plugin.user.access.page.header");
    }

    @Override
    protected String doExecute() throws Exception {
        if (!this.canSeePage()) {
            return "denied";
        }
        if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
            return "restartimporterneeded";
        }
        ImportProcessBean importProcessBean = this.getController().getImportProcessBeanFromSession();
        UserAccessBean userAccessBean = importProcessBean.getUserAccessBean();
        if (!this.bridgeUtils.rolesEnabled() || userAccessBean.isAddingAccess() != null) {
            return this.redirectToFinishPage();
        }
        if (this.isNextClicked()) {
            if (OPTION_DO_NOTHING.equals(this.selectedOption)) {
                userAccessBean.setAddingAccess(false);
            } else if (OPTION_GIVE_ACCESS.equals(this.selectedOption)) {
                userAccessBean.setAddingAccess(true);
                this.giveUserAccess(userAccessBean);
            } else {
                this.addErrorMessage("Unrecognized action selected");
                return "input";
            }
            return this.redirectToFinishPage();
        }
        return "input";
    }

    private void giveUserAccess(UserAccessBean userAccessBean) {
        UserAccessGrantingResult grantingResult = this.bridgeUtils.giveUserAccess(this.selectedApplications, this.getImporter().getCreatedActiveUsers());
        userAccessBean.setUserAccessGrantingResult(grantingResult);
    }

    private String redirectToFinishPage() {
        return this.getRedirect(this.getRedirectURL("ImporterFinishedPage!default.jspa"));
    }

    public UserAccessDataBean getUserAccessMessages() {
        return new UserAccessDataBean(this.getImporter().getCreatedActiveUsers().size(), this.getI18nHelper(), this.getImporterBaseUrlWithSlash(), this.getPluggedPanels());
    }

    public List<?> getApplications() {
        return this.bridgeUtils.getPossibleApplicationSelection();
    }

    @Nullable
    public JiraDataImporter getImporter() {
        ImporterController controller = (ImporterController)Preconditions.checkNotNull((Object)this.getController());
        return controller.getImporter();
    }

    @Override
    @Nonnull
    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-plugin:importerUserAccess");
    }

    public String getPluggedPanels() {
        return this.bridgeUtils.renderWebPanelsFor(USER_ACCESS_LOCATION, this.getContextForPanels());
    }

    private Map<String, Object> getContextForPanels() {
        return ImmutableMap.builder().put((Object)"importerKey", (Object)this.getExternalSystem()).build();
    }

    public static class UserAccessDataBean {
        private final int nubmerOfUsers;
        private final I18nHelper i18Helper;
        private final String baseUrlWithSlash;
        private final String webPanelsHtml;

        public UserAccessDataBean(int numberOfUsers, I18nHelper i18nHelper, String baseUrlWithSlash, String webPanelsHtml) {
            this.nubmerOfUsers = numberOfUsers;
            this.i18Helper = i18nHelper;
            this.baseUrlWithSlash = baseUrlWithSlash;
            this.webPanelsHtml = webPanelsHtml;
        }

        public String getTitle() {
            return this.i18Helper.getText("jira-importer-plugin.user.access.page.title");
        }

        public String getSummary() {
            return this.i18Helper.getText("jira-importer-plugin.user.access.page.summary", String.valueOf(this.nubmerOfUsers));
        }

        public String getOptionLeave() {
            return this.i18Helper.getText("jira-importer-plugin.user.access.page.option.leave", this.baseUrlWithSlash + "user/UserBrowser.jspa");
        }

        public String getOptionManual() {
            return this.i18Helper.getText("jira-importer-plugin.user.access.page.option.manual");
        }

        public String getWebPanelsHtml() {
            return this.webPanelsHtml;
        }
    }
}

