/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.compatibility.UserAccessGrantingResult;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.extensions.ImporterController2;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.PostImportInformations;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterLogsPage;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.plugins.importer.web.TextsUtil;
import com.atlassian.jira.plugins.importer.web.UserAccessBean;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@WebSudoNotRequired
public class ImporterFinishedPage
extends ImporterProcessSupport {
    private static final String STEP_I18N_FINAL = ImporterLogsPage.class.getSimpleName();
    private final CompatibilityBridgeUtils bridgeUtils;

    public ImporterFinishedPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, CompatibilityBridgeUtils bridgeUtils) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.bridgeUtils = bridgeUtils;
    }

    @Override
    public String doDefault() throws Exception {
        return this.doExecute();
    }

    @Override
    protected String doExecute() throws Exception {
        if (!this.canSeePage()) {
            return "denied";
        }
        if (this.getImporter() != null && this.getImporter().getStats() != null) {
            return "input";
        }
        return "restartimporterneeded";
    }

    @Nullable
    public JiraDataImporter getImporter() {
        ImporterController controller = this.getController();
        return controller != null ? controller.getImporter() : null;
    }

    public String getReturnLinks() {
        ImporterController2 controller2 = this.getController2();
        if (controller2 != null && this.getImporter() instanceof PostImportInformations) {
            PostImportInformations.ImportInfo importInfo = ((PostImportInformations)((Object)this.getImporter())).getInfo();
            return controller2.getReturnLinks(importInfo);
        }
        ImportDataBean dataBean = this.getImporter().getDataBean();
        return dataBean != null ? dataBean.getReturnLinks() : "";
    }

    @Override
    @Nullable
    public String getFormTitle() {
        return null;
    }

    @Override
    public String getWizardActiveTab() {
        return STEP_I18N_FINAL;
    }

    @Nonnull
    public Collection<String> getFailures() {
        return Collections2.transform(this.getImporter().getStats().getFailures(), this.convertToHtml());
    }

    private Function<String, String> convertToHtml() {
        return new Function<String, String>(){

            public String apply(@Nullable String input) {
                return TextsUtil.convertToNiceHtmlString(input);
            }
        };
    }

    @Nonnull
    public Collection<String> getWarnings() {
        return Collections2.transform(this.getImporter().getStats().getWarnings(), this.convertToHtml());
    }

    public boolean shouldDisplayUserAccessPanel() {
        return this.isAddingAccess();
    }

    public boolean isUserAccessSuccess() {
        UserAccessBean userAccessBean = this.getUserAccessBean();
        UserAccessGrantingResult result = userAccessBean.getUserAccessGrantingResult();
        return this.isAddingAccess() && result.getUsersLeftInactive() <= 0 && result.getUsersGrantError() <= 0;
    }

    private boolean isAddingAccess() {
        UserAccessBean userAccessBean = this.getUserAccessBean();
        return userAccessBean != null && userAccessBean.isAddingAccess() != null && userAccessBean.isAddingAccess() != false;
    }

    public String getUserAccessInformation() {
        UserAccessBean userAccessBean = this.getUserAccessBean();
        if (!this.isAddingAccess()) {
            return "";
        }
        UserAccessGrantingResult result = userAccessBean.getUserAccessGrantingResult();
        String messageKey = result.getUsersLeftInactive() > 0 && result.getUsersGrantError() > 0 ? "jira-importer-plugin.finished.page.user.access.inactive.and.errors" : (result.getUsersLeftInactive() > 0 ? "jira-importer-plugin.finished.page.user.access.inactive" : (result.getUsersGrantError() > 0 ? "jira-importer-plugin.finished.page.user.access.errors" : "jira-importer-plugin.finished.page.user.access.success"));
        return this.getI18nHelper().getText(messageKey, (Object)result.getUsersGrantedAccess(), (Object)result.getUsersLeftInactive(), (Object)result.getUsersGrantError());
    }

    public Collection<String> getUserAccessErrors() {
        UserAccessBean userAccessBean = this.getUserAccessBean();
        if (!this.isAddingAccess()) {
            return ImmutableList.of();
        }
        return userAccessBean.getUserAccessGrantingResult().getErrorCollection().getErrorMessages();
    }

    private UserAccessBean getUserAccessBean() {
        ImporterController controller = (ImporterController)Preconditions.checkNotNull((Object)this.getController());
        ImportProcessBean processBeanFromSession = controller.getImportProcessBeanFromSession();
        if (processBeanFromSession == null) {
            return null;
        }
        return processBeanFromSession.getUserAccessBean();
    }
}

