/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ConsoleImportLogger;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import webwork.action.ActionContext;

public class ImporterCustomFieldsPage
extends ImporterProcessSupport.Database {
    private List<ExternalCustomField> customFields = Collections.emptyList();
    private Map<ExternalCustomField, Map<String, Map<String, String>>> availableFieldMappings = Collections.emptyMap();

    public ImporterCustomFieldsPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
    }

    @Override
    @RequiresXsrfCheck
    protected void doValidation() {
        AbstractConfigBean2 configBean = this.getConfigBean();
        if (configBean != null) {
            configBean.populateFieldMappings(ActionContext.getParameters(), (ErrorCollection)this);
        }
    }

    @Override
    protected void prepareModel() throws Exception {
        AbstractConfigBean2 configBean = this.getConfigBean();
        this.customFields = configBean.getCustomFields();
        this.availableFieldMappings = Maps.newHashMapWithExpectedSize((int)this.customFields.size());
        Set<ExternalProject> projects = this.getController().createDataBean().getSelectedProjects(ConsoleImportLogger.INSTANCE);
        for (ExternalCustomField customField : this.customFields) {
            Map<String, Map<String, String>> mappings = configBean.getAvailableFieldMappings(customField, projects);
            this.availableFieldMappings.put(customField, mappings);
        }
    }

    public Map<String, Map<String, String>> getAvailableFieldMappings(ExternalCustomField customField) {
        return this.availableFieldMappings.get(customField);
    }

    public List<ExternalCustomField> getCustomFields() {
        return this.customFields;
    }

    public String getFieldMapping(String fieldName) {
        AbstractConfigBean2 configBean = this.getConfigBean();
        return configBean != null ? configBean.getFieldMapping(fieldName) : null;
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.set.up.custom.fields");
    }
}

