/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AddCustomFieldDialog
extends JiraWebActionSupport {
    public static final String CUSTOM_FIELD_TYPE = "customFieldType";
    public static final String CUSTOM_FIELD_NAME = "customFieldName";
    private String customFieldName;
    private String customFieldType;
    private final CustomFieldManager customFieldManager;

    public AddCustomFieldDialog(@ComponentImport CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    protected void doValidation() {
        if (StringUtils.isBlank((String)this.customFieldType)) {
            this.addError(CUSTOM_FIELD_TYPE, this.getText("admin.errors.customfields.no.field.type.specified"));
        } else {
            try {
                if (this.customFieldManager.getCustomFieldType(this.customFieldType) == null) {
                    this.addError(CUSTOM_FIELD_TYPE, this.getText("admin.errors.customfields.invalid.field.type"));
                }
            }
            catch (IllegalArgumentException e) {
                this.addError(CUSTOM_FIELD_TYPE, this.getText("admin.errors.customfields.invalid.field.type"));
            }
        }
        if (StringUtils.isBlank((String)this.customFieldName)) {
            this.addError(CUSTOM_FIELD_NAME, this.getText("admin.errors.customfields.no.name"));
        }
    }

    protected String doExecute() throws Exception {
        return this.returnComplete();
    }

    public Map<String, String> getCustomFieldTypes() {
        ArrayList customFieldTypes = Lists.newArrayList((Iterable)this.customFieldManager.getCustomFieldTypes());
        LinkedHashMap customFieldMap = Maps.newLinkedHashMap();
        for (CustomFieldType fieldType : customFieldTypes) {
            customFieldMap.put(fieldType.getKey(), fieldType.getName());
        }
        return customFieldMap;
    }

    public String getCustomFieldName() {
        return this.customFieldName;
    }

    public void setCustomFieldName(String customFieldName) {
        this.customFieldName = customFieldName;
    }

    public String getCustomFieldType() {
        return this.customFieldType;
    }

    public void setCustomFieldType(String customFieldType) {
        this.customFieldType = customFieldType;
    }
}

