/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.views;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issueview.IssueView;
import com.atlassian.jira.plugin.issueview.IssueViewModuleDescriptor;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParams;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.plugins.importer.exports.IssuesExporter;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.plugins.importer.sample.mapper.ObjectMapperFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.io.IOException;

public class IssueJsonView
implements IssueView {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final IssuesExporter issuesExporter;
    private final ObjectMapperFactory objectMapperFactory;

    public IssueJsonView(@ComponentImport PermissionManager permissionManager, @ComponentImport JiraAuthenticationContext authenticationContext, IssuesExporter issuesExporter, ObjectMapperFactory objectMapperFactory) {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.issuesExporter = issuesExporter;
        this.objectMapperFactory = objectMapperFactory;
    }

    public void init(IssueViewModuleDescriptor issueViewModuleDescriptor) {
    }

    public String getContent(Issue issue, IssueViewRequestParams issueViewRequestParams) {
        if (!this.permissionManager.hasPermission(0, this.authenticationContext.getUser())) {
            return this.authenticationContext.getI18nHelper().getText("jira-importer-plugin.must.be.admin");
        }
        SampleData data = this.issuesExporter.exportIssues((Iterable<Long>)ImmutableList.of((Object)issue.getId()));
        try {
            return this.objectMapperFactory.createMapper().writeValueAsString((Object)data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeHeaders(Issue issue, RequestHeaders requestHeaders, IssueViewRequestParams issueViewRequestParams) {
        JiraHttpUtils.setNoCacheHeaders((RequestHeaders)requestHeaders);
    }
}

