/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.util.iterator;

import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.util.iterator.ItemFactory;
import java.util.Iterator;
import java.util.LinkedList;

public class CachingIterator<T>
implements Iterator<T> {
    private final LinkedList<T> cache = new LinkedList();
    private final ItemFactory<T> factory;
    private final ImportLogger log;

    public CachingIterator(ItemFactory<T> factory, ImportLogger log) {
        this.factory = factory;
        this.log = log;
    }

    @Override
    public boolean hasNext() {
        if (!this.cache.isEmpty()) {
            return true;
        }
        try {
            this.cache.addAll(this.factory.getNewItems());
        }
        catch (Exception e) {
            this.log.warn(e, "Cannot fetch issues, " + e.getMessage(), new Object[0]);
        }
        return !this.cache.isEmpty();
    }

    @Override
    public T next() {
        return this.cache.remove();
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This iterator does not implement remove()");
    }
}

