/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.sample.mapper;

import com.google.common.base.Optional;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class PeriodAwareStringSerializer
extends JsonSerializer<String> {
    private static final String START_OF_PERIOD = "P";

    public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value != null && value.startsWith(START_OF_PERIOD)) {
            Optional<Period> period = this.tryParse(value);
            if (period.isPresent()) {
                provider.defaultSerializeValue((Object)DateTime.now().plus((ReadablePeriod)period.get()), jgen);
            }
        } else {
            jgen.writeString(value);
        }
    }

    private Optional<Period> tryParse(String value) {
        try {
            return Optional.of((Object)Period.parse((String)value));
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }

    public Class<String> handledType() {
        return String.class;
    }
}

