/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.sample.mapper;

import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.ext.JodaDeserializers;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

class PeriodAwareDateDeserializer
extends JodaDeserializers.DateTimeDeserializer<DateTime> {
    public PeriodAwareDateDeserializer() {
        super(DateTime.class);
    }

    public DateTime deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            try {
                Period p = Period.parse((String)str);
                if (p != null) {
                    return new DateTime().plus((ReadablePeriod)p);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return (DateTime)super.deserialize(jp, deserializationContext);
    }
}

