/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.sample.mapper;

import com.atlassian.jira.plugins.importer.sample.mapper.DateTimeSerializer;
import com.atlassian.jira.plugins.importer.sample.mapper.ObjectMapperFactory;
import com.atlassian.jira.plugins.importer.sample.mapper.PeriodAwareDateDeserializer;
import com.atlassian.jira.plugins.importer.sample.mapper.PeriodAwareStringSerializer;
import com.atlassian.jira.plugins.importer.sample.mapper.PeriodDeserializer;
import com.atlassian.jira.plugins.importer.sample.mapper.PeriodSerializer;
import com.atlassian.jira.plugins.importer.sample.mapper.fugue.com.OptionFilter;
import com.atlassian.jira.plugins.importer.sample.mapper.fugue.io.OptionFilterAnnotationHoldingMixIn;
import com.atlassian.jira.plugins.importer.sample.mapper.fugue.io.OptionSerializer;
import com.google.common.base.Optional;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.BeanPropertyFilter;
import org.codehaus.jackson.map.ser.FilterProvider;
import org.codehaus.jackson.map.ser.impl.SimpleFilterProvider;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.springframework.stereotype.Component;

@Component
public class ObjectMapperFactoryImpl
implements ObjectMapperFactory {
    @Override
    public ObjectMapper createMapper() {
        return this.createMapper((Optional<DateTime>)Optional.absent(), false);
    }

    @Override
    public ObjectMapper createRelativeTimeMapper(DateTime timeReference) {
        return this.createMapper((Optional<DateTime>)Optional.of((Object)timeReference), false);
    }

    @Override
    public ObjectMapper createPeriodAwareMapper() {
        return this.createMapper((Optional<DateTime>)Optional.absent(), true);
    }

    private ObjectMapper createMapper(Optional<DateTime> timeReference, boolean periodString) {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("JIM External Issues Mapper", Version.unknownVersion()).addDeserializer(DateTime.class, (JsonDeserializer)new PeriodAwareDateDeserializer()).addDeserializer(Period.class, (JsonDeserializer)new PeriodDeserializer()).addSerializer((JsonSerializer)new PeriodSerializer()).addSerializer((JsonSerializer)new com.atlassian.jira.plugins.importer.sample.mapper.fugue.com.OptionSerializer()).addSerializer((JsonSerializer)new DateTimeSerializer(timeReference));
        if (periodString) {
            module.addSerializer((JsonSerializer)new PeriodAwareStringSerializer());
        }
        objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        objectMapper.getSerializationConfig().addMixInAnnotations(Object.class, com.atlassian.jira.plugins.importer.sample.mapper.fugue.com.OptionFilterAnnotationHoldingMixIn.class);
        objectMapper.setFilters((FilterProvider)new SimpleFilterProvider().addFilter("ignoreEmptyComOptions", (BeanPropertyFilter)new OptionFilter()));
        if (ObjectMapperFactoryImpl.isClazzPresent("io.atlassian.fugue.Option")) {
            module.addSerializer((JsonSerializer)new OptionSerializer());
            objectMapper.getSerializationConfig().addMixInAnnotations(Object.class, OptionFilterAnnotationHoldingMixIn.class);
            objectMapper.setFilters((FilterProvider)new SimpleFilterProvider().addFilter("ignoreEmptyIoOptions", (BeanPropertyFilter)new com.atlassian.jira.plugins.importer.sample.mapper.fugue.io.OptionFilter()));
        }
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    private static boolean isClazzPresent(String clazzName) {
        try {
            Class.forName(clazzName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

