/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.sample.mapper;

import com.google.common.base.Optional;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

class DateTimeSerializer
extends JsonSerializer<DateTime> {
    private final Optional<DateTime> timeReference;

    public DateTimeSerializer(Optional<DateTime> timeReference) {
        this.timeReference = timeReference;
    }

    public void serialize(DateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Long objectToSerialize = value.getMillis();
        if (this.timeReference.isPresent() && value.getMillis() > 0L) {
            Period period = new Period((ReadableInstant)this.timeReference.get(), (ReadableInstant)value);
            objectToSerialize = period.withField(DurationFieldType.millis(), 0).withField(DurationFieldType.seconds(), 0);
        }
        provider.defaultSerializeValue((Object)objectToSerialize, jgen);
    }

    public Class<DateTime> handledType() {
        return DateTime.class;
    }
}

