/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.sample;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.AttachmentImportException;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.sample.AttachmentsProvider;
import com.atlassian.jira.plugins.importer.sample.AvatarsProvider;
import com.atlassian.jira.plugins.importer.sample.Callbacks;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class SampleDataBean
extends ImportDataBean {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ConstantsManager constantsManager;
    private final SampleData sampleData;
    private final AttachmentsProvider attachmentsProvider;
    private final AvatarsProvider avatarsProvider;
    private final Callbacks callbacks;

    public SampleDataBean(JiraAuthenticationContext jiraAuthenticationContext, ConstantsManager constantsManager, SampleData sampleData, AttachmentsProvider attachmentsProvider, AvatarsProvider avatarsProvider, Callbacks callbacks) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.constantsManager = constantsManager;
        this.sampleData = sampleData;
        this.attachmentsProvider = attachmentsProvider;
        this.avatarsProvider = avatarsProvider;
        this.callbacks = callbacks;
    }

    @Override
    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    @Override
    public Set<ExternalUser> getAllUsers(ImportLogger log) {
        return this.sampleData.getUsers();
    }

    @Override
    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        return this.sampleData.getProjects();
    }

    @Override
    public Set<ExternalProject> getSelectedProjects(ImportLogger log) {
        return this.getAllProjects(log);
    }

    @Override
    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        Set<ExternalVersion> versions = externalProject.getVersions();
        return versions != null ? versions : Collections.emptySet();
    }

    @Override
    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        Set<ExternalComponent> components = externalProject.getComponents();
        return components != null ? components : Collections.emptySet();
    }

    @Override
    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        List<ExternalIssue> issues = externalProject.getIssues();
        return issues != null ? issues.iterator() : ImmutableList.of().iterator();
    }

    @Override
    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        if (this.attachmentsProvider != null) {
            ArrayList importedAttachments = Lists.newArrayList();
            for (ExternalAttachment attachment : externalIssue.getAttachments()) {
                try {
                    if (attachment.getAttachment() == null) {
                        attachment.setAttachment(this.attachmentsProvider.getAttachmentForIssue(externalIssue, attachment.getName(), log));
                    }
                    importedAttachments.add(attachment);
                }
                catch (AttachmentImportException e) {
                    log.warn(e, e.getMessage(), new Object[0]);
                }
            }
            return importedAttachments;
        }
        return Collections.emptyList();
    }

    @Override
    public File getAvatarForProject(ExternalProject externalProject, ImportLogger log) {
        return this.avatarsProvider != null ? this.avatarsProvider.getAvatarForProject(externalProject, log) : null;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getIssueKeyRegex() {
        return null;
    }

    @Override
    public Collection<ExternalLink> getLinks(ImportLogger log) {
        return this.sampleData.getLinks();
    }

    @Override
    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger log) {
        long count = 0L;
        for (ExternalProject project : selectedProjects) {
            List<ExternalIssue> issues = project.getIssues();
            if (issues == null) continue;
            count += (long)issues.size();
        }
        return count;
    }

    @Override
    @Nonnull
    public Callbacks getCallbacks() {
        return this.callbacks != null ? this.callbacks : super.getCallbacks();
    }

    @Override
    public String getUnusedUsersGroup() {
        return null;
    }

    @Override
    public String getReturnLinks() {
        return String.format("<div id=\"importAgain\"><a href=\"ExternalImport1.jspa\">%s</a></div>", this.jiraAuthenticationContext.getI18nHelper().getText("jira-importer-plugin.ImporterLogsPage.import.another"));
    }
}

