/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.rest.json;

import com.atlassian.fugue.Either;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.json.rest.JsonRestImportService;
import com.atlassian.jira.plugins.importer.rest.json.AcceptedImportEntity;
import com.atlassian.jira.plugins.importer.rest.json.ErrorEntity;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.plugins.importer.sample.SampleDataImporterImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

@Path(value="importer/json")
@Consumes(value={"application/json"})
public class JsonImporterResource {
    public static final Logger log = Logger.getLogger(JsonImporterResource.class);
    private static final CacheControl NO_CACHE = new CacheControl();
    private JsonRestImportService jsonRestImportService;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private PermissionManager permissionManager;

    private JsonImporterResource() {
    }

    public JsonImporterResource(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, JsonRestImportService jsonRestImportService, @ComponentImport PermissionManager permissionManager) {
        this.jsonRestImportService = jsonRestImportService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
    }

    @POST
    @Produces(value={"application/json"})
    public Response jsonImport(@Context HttpServletRequest req, InputStream is) {
        Optional<UUID> uuid;
        Either<SampleData, Response> checkResult = this.checkPreconditions(is);
        if (checkResult.isRight()) {
            return (Response)checkResult.right().get();
        }
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.jsonRestImportService.isImporterRunning(user) && (uuid = this.jsonRestImportService.startImport(user, (SampleData)checkResult.left().get())).isPresent()) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)AcceptedImportEntity.fromReq(req, (UUID)uuid.get())).build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ErrorEntity("Import is already running, please abort current request or wait until it's finished.")).build();
    }

    @GET
    @Path(value="job/{uuid}")
    @Produces(value={"application/json"})
    public Response status(@PathParam(value="uuid") String uuid) {
        Either<JiraDataImporter, Response> checkResult = this.checkImporterIsAvailable(uuid);
        if (checkResult.isRight()) {
            return (Response)checkResult.right().get();
        }
        JiraDataImporter importer = (JiraDataImporter)checkResult.left().get();
        return Response.ok((Object)importer.getStats()).build();
    }

    @DELETE
    @Path(value="job/{uuid}")
    public Response abort(@PathParam(value="uuid") String uuid) {
        Either<JiraDataImporter, Response> checkResult = this.checkImporterIsAvailable(uuid);
        if (checkResult.isRight()) {
            return (Response)checkResult.right().get();
        }
        JiraDataImporter importer = (JiraDataImporter)checkResult.left().get();
        if (importer.isRunning() && !importer.isAborted()) {
            importer.abort(this.jiraAuthenticationContext.getUser().getName());
            return Response.status((Response.Status)Response.Status.ACCEPTED).cacheControl(NO_CACHE).build();
        }
        return Response.noContent().cacheControl(NO_CACHE).build();
    }

    @GET
    @Path(value="job/{uuid}/log")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response log(@PathParam(value="uuid") String uuid) {
        Either<JiraDataImporter, Response> checkResult = this.checkImporterIsAvailable(uuid);
        if (checkResult.isRight()) {
            return (Response)checkResult.right().get();
        }
        JiraDataImporter importer = (JiraDataImporter)checkResult.left().get();
        ImportLogger importLogger = importer.getLog();
        if (importLogger == null) {
            return Response.noContent().cacheControl(NO_CACHE).build();
        }
        return Response.ok((Object)importLogger.getImportLog()).cacheControl(NO_CACHE).build();
    }

    private Either<JiraDataImporter, Response> checkImporterIsAvailable(String stringUUID) {
        UUID uuid;
        Optional<Response> errorResponse = this.canUseResource();
        if (errorResponse.isPresent()) {
            return Either.right((Object)errorResponse.get());
        }
        try {
            uuid = UUID.fromString(stringUUID);
        }
        catch (IllegalArgumentException e) {
            return Either.right((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(NO_CACHE).entity((Object)new ErrorEntity("Provided UUID is invalid")).build());
        }
        Optional<JiraDataImporter> importer = this.jsonRestImportService.getImporter(uuid, this.jiraAuthenticationContext.getUser());
        if (importer.isPresent()) {
            return Either.left((Object)importer.get());
        }
        return Either.right((Object)Response.status((Response.Status)Response.Status.GONE).cacheControl(NO_CACHE).build());
    }

    private Either<SampleData, Response> checkPreconditions(InputStream is) {
        SampleData sampleData;
        String json;
        Optional<Response> errorResponse = this.canUseResource();
        if (errorResponse.isPresent()) {
            return Either.right((Object)errorResponse.get());
        }
        try {
            json = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            log.warn((Object)"Cannot parse JSON message", (Throwable)e);
            return Either.right((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(NO_CACHE).entity((Object)new ErrorEntity("Incoming JSON message cannot be read")).build());
        }
        try {
            ObjectMapper jsonObjectMapper = SampleDataImporterImpl.getObjectMapper();
            sampleData = (SampleData)jsonObjectMapper.readValue(json, SampleData.class);
        }
        catch (IOException e) {
            log.warn((Object)"Cannot parse JSON message", (Throwable)e);
            return Either.right((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(NO_CACHE).entity((Object)new ErrorEntity("Cannot parse JSON message: " + e.getMessage())).build());
        }
        return Either.left((Object)sampleData);
    }

    private Optional<Response> canUseResource() {
        if (!this.permissionManager.hasPermission(0, this.jiraAuthenticationContext.getUser())) {
            return Optional.of((Object)Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(NO_CACHE).entity((Object)new ErrorEntity("You need to be at least JIRA Administrator")).build());
        }
        return Optional.absent();
    }

    static {
        NO_CACHE.setNoStore(true);
        NO_CACHE.setNoCache(true);
    }
}

