/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.rest.json;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class AcceptedImportEntity {
    private final JobResource job;
    private final String id;
    public static final AcceptedImportEntity DOC_EXAMPLE = new AcceptedImportEntity("f3e56517-368d-422d-bbc1-4cb18d6a87f7", "http://www.example.com/jira/rest/jira-importers-plugin/1.0/importer/json/job/f3e56517-368d-422d-bbc1-4cb18d6a87f7", "http://www.example.com/jira/rest/jira-importers-plugin/1.0/importer/json/job/f3e56517-368d-422d-bbc1-4cb18d6a87f7/log");

    @JsonCreator
    public AcceptedImportEntity(@JsonProperty(value="id") String id, @JsonProperty(value="url") JobResource job) {
        this.id = id;
        this.job = job;
    }

    public AcceptedImportEntity(String id, String job, String log) {
        this.id = id;
        this.job = new JobResource(job, log);
    }

    public JobResource getJob() {
        return this.job;
    }

    public String getId() {
        return this.id;
    }

    public static AcceptedImportEntity fromReq(HttpServletRequest req, UUID uuid) {
        String restUrl = AcceptedImportEntity.getBaseUrl(req) + "/rest/jira-importers-plugin/1.0/importer/json/job/";
        String jobUrl = restUrl + uuid;
        String logUrl = jobUrl + "/log";
        return new AcceptedImportEntity(uuid.toString(), jobUrl, logUrl);
    }

    private static String getBaseUrl(HttpServletRequest httpRequest) {
        String requestUrl = httpRequest.getRequestURL().toString();
        return requestUrl.replace(httpRequest.getRequestURI(), httpRequest.getContextPath());
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class JobResource {
        private final String url;
        private final String log;

        @JsonCreator
        private JobResource(@JsonProperty(value="url") String job, @JsonProperty(value="log") String log) {
            this.url = job;
            this.log = log;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLog() {
            return this.log;
        }
    }
}

