/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.rest;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.compatibility.ProjectTypeInfo;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="validation")
@Produces(value={"application/json"})
public class ValidationResource {
    private final JiraAuthenticationContext authenticationContext;
    private final CompatibilityBridgeUtils bridgeUtils;
    private final VelocityTemplatingEngine templatingEngine;

    public ValidationResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport VelocityTemplatingEngine templatingEngine, CompatibilityBridgeUtils bridgeUtils) {
        this.authenticationContext = authenticationContext;
        this.bridgeUtils = bridgeUtils;
        this.templatingEngine = templatingEngine;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/validateProject")
    public Response validateProject(@FormParam(value="key") String projectKey, @FormParam(value="name") String projectName, @FormParam(value="type") String projectType) {
        String leadName = this.authenticationContext.getUser().getName();
        ProjectService.CreateProjectValidationResult createProjectValidationResult = this.bridgeUtils.validateCreateProject(this.authenticationContext.getUser(), projectName, projectKey, "", leadName, "", null, projectType, null);
        HashMap data = Maps.newHashMap((Map)createProjectValidationResult.getErrorCollection().getErrors());
        if (createProjectValidationResult.isValid()) {
            data.put("key", projectKey);
            data.put("name", projectName);
            data.put("lead", leadName);
            data.put("type", projectType);
            data.put("valid", "true");
        }
        return Response.ok((Object)data).build();
    }

    @GET
    @Path(value="/project")
    public Response getDialogHtml(@QueryParam(value="keyEdited") boolean keyEdited) {
        VelocityTemplatingEngine.RenderRequest renderRequest = this.templatingEngine.render(TemplateSources.file((String)this.getClass().getResource("/templates/standard/addproject.vm").getPath()));
        List<ProjectTypeInfo> projectTypes = this.bridgeUtils.getProjectTypes();
        ImmutableMap params = ImmutableMap.of((Object)"i18n", (Object)this.authenticationContext.getI18nHelper(), (Object)"keyEdited", (Object)keyEdited, (Object)"shouldShowProjectTypes", (Object)(projectTypes.size() > 1 ? 1 : 0), (Object)"projectTypes", projectTypes);
        renderRequest.applying((Map)params);
        return Response.ok((Object)renderRequest.asHtml(), (MediaType)MediaType.TEXT_HTML_TYPE).build();
    }
}

