/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.rest;

import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

@Path(value="plugin")
@Produces(value={"application/json"})
public class PluginResource {
    private static final Logger log = Logger.getLogger(PluginResource.class);
    private static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    private static final String PAC_FIND_COMPATIBLE_PATH = "https://plugins.atlassian.com/server/1.0/pluginversion/find/compatiblekey/jira/%s/%s";
    public static final String PLUGIN_KEY = "com.atlassian.jira.plugins.jira-importers-plugin";
    private final PluginAccessor pluginAccessor;
    private final BuildUtilsInfo buildUtilsInfo;
    private final AtomicBoolean upgradeAvailable = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Date lastCheck;

    public PluginResource(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport BuildUtilsInfo buildUtilsInfo) {
        this.pluginAccessor = pluginAccessor;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/upgradeAvailable")
    public Response isUpgradeAvailable() {
        block7: {
            if (this.running.compareAndSet(false, true)) {
                try {
                    PluginInformation pi;
                    Date now = new Date();
                    if (this.lastCheck != null && now.getTime() <= this.lastCheck.getTime() + 86400000L) break block7;
                    this.lastCheck = now;
                    Plugin plugin = this.pluginAccessor.getPlugin(PLUGIN_KEY);
                    if (plugin == null || (pi = plugin.getPluginInformation()) == null) break block7;
                    String version = pi.getVersion();
                    try {
                        String pacVersion = this.getVersionFromPac();
                        if (StringUtils.isNotEmpty((String)pacVersion)) {
                            this.upgradeAvailable.set(!version.equals(pacVersion));
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)"Unabled to check current release on PAC", (Throwable)e);
                    }
                }
                finally {
                    this.running.set(false);
                }
            }
        }
        return Response.ok((Object)this.upgradeAvailable.get()).build();
    }

    @Nullable
    public String getVersionFromPac() throws IOException, SAXException, JDOMException, JaxenException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(String.format(PAC_FIND_COMPATIBLE_PATH, this.buildUtilsInfo.getCurrentBuildNumber(), PLUGIN_KEY));
        client.executeMethod((HttpMethod)method);
        return this.getVersionFromXml(method.getResponseBodyAsStream());
    }

    @Nullable
    public String getVersionFromXml(InputStream input) throws IOException, SAXException, JDOMException, JaxenException {
        Element root = XmlUtil.getSAXBuilder().build(input).getRootElement();
        Object version = new JDOMXPath("/items/item/version").selectSingleNode((Object)root);
        if (version instanceof Element) {
            return ((Element)version).getText();
        }
        return null;
    }
}

