/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.managers;

import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkCreator;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugins.importer.managers.CreateIssueLinkManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateIssueLinkManagerImpl
implements CreateIssueLinkManager {
    private final IssueLinkManager issueLinkManager;
    private final IssueIndexManager issueIndexManager;
    private final IssueLinkCreator issueLinkCreator;
    private final OfBizDelegator delegator;
    private static final String LINK_TYPE_ID_FIELD_NAME = "linktype";
    private static final String SOURCE_ID_FIELD_NAME = "source";
    private static final String DESTINATION_ID_LINK_NAME = "destination";
    private static final String SEQUENCE_FIELD_NAME = "sequence";

    @Autowired
    public CreateIssueLinkManagerImpl(@ComponentImport IssueLinkManager issueLinkManager, @ComponentImport IssueIndexManager issueIndexManager, @ComponentImport IssueLinkCreator issueLinkCreator, @ComponentImport OfBizDelegator delegator) {
        this.issueLinkManager = issueLinkManager;
        this.issueIndexManager = issueIndexManager;
        this.issueLinkCreator = issueLinkCreator;
        this.delegator = delegator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId, @Nullable Long sequence) throws CreateException {
        if (this.issueLinkManager.getIssueLink(sourceId, destinationId, issueLinkTypeId) != null) {
            return;
        }
        IssueLink issueLink = null;
        try {
            issueLink = this.storeIssueLink(sourceId, destinationId, issueLinkTypeId, sequence);
        }
        finally {
            this.issueLinkManager.clearCache();
            if (issueLink != null) {
                this.reindexLinkedIssues(issueLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IssueLink storeIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId, Long sequence) {
        try {
            HashMap map = Maps.newHashMap();
            map.put(SOURCE_ID_FIELD_NAME, sourceId);
            map.put(DESTINATION_ID_LINK_NAME, destinationId);
            map.put(LINK_TYPE_ID_FIELD_NAME, issueLinkTypeId);
            map.put(SEQUENCE_FIELD_NAME, sequence);
            IssueLink issueLink = this.issueLinkCreator.createIssueLink(this.delegator.createValue("IssueLink", (Map)map));
            return issueLink;
        }
        finally {
            this.issueLinkManager.clearCache();
        }
    }

    protected void reindexLinkedIssues(IssueLink issueLink) {
        try {
            this.issueIndexManager.reIndex(issueLink.getSourceObject());
            this.issueIndexManager.reIndex(issueLink.getDestinationObject());
        }
        catch (IndexException e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }
}

