/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RequiredUserTransformer
extends AbstractResultSetTransformer<ExternalUser> {
    private final TracConfigBean configBean;

    public RequiredUserTransformer(TracConfigBean configBean, ImportLogger log) {
        super(log);
        this.configBean = configBean;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT owner FROM ticket UNION SELECT reporter FROM ticket UNION SELECT author FROM attachment WHERE type='ticket' UNION SELECT author FROM ticket_change WHERE field='comment' UNION SELECT owner FROM component";
    }

    @Override
    @Nullable
    public ExternalUser transform(ResultSet rs) throws SQLException {
        String fullName = TracConfigBean.extractFullName(rs.getString(1));
        String username = this.configBean.getUsernameForEmail(rs.getString(1));
        if (StringUtils.isBlank((String)username)) {
            this.log.warn("Username is blank and is not imported", new Object[0]);
            return null;
        }
        ExternalUser user = new ExternalUser(username, StringUtils.isEmpty((String)fullName) ? RequiredUserTransformer.getFullNameFromEmail(username) : fullName, username);
        return user;
    }

    @Nullable
    public static ExternalUser transform(TracConfigBean configBean, String email, ImportLogger log) {
        String fullName = TracConfigBean.extractFullName(email);
        String username = configBean.getUsernameForEmail(email);
        if (StringUtils.isBlank((String)username)) {
            log.warn("Username is blank and is not imported", new Object[0]);
            return null;
        }
        ExternalUser user = new ExternalUser(username, StringUtils.isEmpty((String)fullName) ? RequiredUserTransformer.getFullNameFromEmail(username) : fullName, username);
        return user;
    }

    protected static String getFullNameFromEmail(String email) {
        if (email == null) {
            return "";
        }
        int index = email.indexOf("@");
        if (index != -1) {
            return email.substring(0, index);
        }
        return "";
    }
}

