/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac.transformer;

import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.AbstractIssueTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.SingleStringResultTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import com.atlassian.jira.plugins.importer.imports.trac.TracWikiConverter;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.CommentTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.WatchersTransformer;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class IssueTransformer
extends AbstractIssueTransformer<TracConfigBean> {
    private final TracWikiConverter wikiConverter;

    public IssueTransformer(TracConfigBean configBean, ImportLogger importLogger, TracWikiConverter wikiConverter) {
        super(configBean, importLogger);
        this.wikiConverter = wikiConverter;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT id,type,time,changetime,component,severity,priority,owner,reporter,cc,version,milestone,status,resolution,summary,description,keywords FROM ticket";
    }

    @Override
    public ExternalIssue transform(ResultSet rs) throws SQLException {
        String assignee;
        String reporter;
        String version;
        String summary = rs.getString("summary");
        if (StringUtils.isEmpty((String)summary)) {
            this.log.warn("Summary is blank and is not imported", new Object[0]);
            return null;
        }
        String oldId = rs.getString("id");
        ExternalIssue externalIssue = new ExternalIssue();
        externalIssue.setExternalId(oldId);
        externalIssue.setSummary(summary);
        externalIssue.setDescription(this.wikiConverter.convert(rs.getString("description"), this.log));
        String issueType = rs.getString("type");
        String translatedIssueType = ((TracConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport("type", issueType);
        externalIssue.setIssueType(translatedIssueType);
        String component = rs.getString("component");
        if (StringUtils.isNotBlank((String)component)) {
            externalIssue.setComponents(Collections.singleton(component));
        }
        if (StringUtils.isNotBlank((String)(version = rs.getString("version")))) {
            externalIssue.setAffectedVersions(Collections.singleton(version));
        }
        if (StringUtils.isNotEmpty((String)(reporter = rs.getString("reporter")))) {
            externalIssue.setReporter(((TracConfigBean)this.configBean).getUsernameForEmail(reporter));
        }
        if (StringUtils.isNotEmpty((String)(assignee = rs.getString("owner")))) {
            externalIssue.setAssignee(((TracConfigBean)this.configBean).getUsernameForEmail(assignee));
        }
        externalIssue.setCreated(((TracConfigBean)this.configBean).getTimestamp(rs, "time"));
        externalIssue.setLabels(LabelParser.buildFromString((LabelParser.CreateFromString)new LabelParser.CreateFromString<String>(){

            public String create(String s) {
                return s;
            }
        }, (String)rs.getString("keywords")));
        Date closed = ((TracConfigBean)this.configBean).getTimestamp(rs, "changetime");
        Date resolved = ((TracConfigBean)this.configBean).getTimestamp(rs, "changetime");
        externalIssue.setResolutionDate(resolved);
        if (closed != null && resolved == null) {
            externalIssue.setUpdated(closed);
        } else if (closed == null && resolved != null) {
            externalIssue.setUpdated(resolved);
        } else if (closed != null) {
            if (closed.after(resolved)) {
                externalIssue.setUpdated(closed);
            } else {
                externalIssue.setUpdated(resolved);
            }
        }
        this.setCustomFieldValues(externalIssue, rs, oldId);
        externalIssue.setStatus(((TracConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport("status", rs.getString("status")));
        externalIssue.setResolution(((TracConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport("resolution", rs.getString("resolution")));
        CommentTransformer commentTransformer = new CommentTransformer(oldId, (TracConfigBean)this.configBean, this.wikiConverter, this.log);
        List<ExternalComment> comments = this.jdbcConnection.queryDb(commentTransformer);
        externalIssue.setComments(comments);
        WatchersTransformer watchersTransformer = new WatchersTransformer(oldId);
        externalIssue.setWatchers(this.jdbcConnection.queryDbAppendCollection(watchersTransformer));
        return externalIssue;
    }

    @Override
    @Nullable
    protected Object getCustomFieldValue(ResultSet rs, String bugId, ExternalCustomField customField) throws SQLException {
        String dbValue;
        if (SqlUtils.getColumnNames(rs.getMetaData()).contains(customField.getId())) {
            dbValue = rs.getString(customField.getId());
        } else {
            List<String> result = this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT value FROM ticket_custom WHERE name = '" + customField.getId() + "' AND ticket=" + bugId));
            dbValue = (String)Iterables.getFirst(result, null);
        }
        if ("com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes".equals(customField.getTypeKey())) {
            String string = dbValue = "1".equals(dbValue) ? customField.getName() : null;
        }
        if (StringUtils.isBlank((String)dbValue)) {
            return null;
        }
        String mappedValue = ((TracConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport(customField.getId(), dbValue);
        if (mappedValue != null && ("com.atlassian.jira.plugin.system.customfieldtypes:multiselect".equals(customField.getTypeKey()) || "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes".equals(customField.getTypeKey()))) {
            return Lists.newArrayList((Object[])new String[]{mappedValue});
        }
        return StringUtils.trimToNull((String)mappedValue);
    }
}

