/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.RequiredUserTransformer;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ActiveWatchersTransformer
implements ResultSetTransformer<Collection<ExternalUser>> {
    private final TracConfigBean configBean;
    private final ImportLogger log;

    public ActiveWatchersTransformer(TracConfigBean configBean, ImportLogger log) {
        this.configBean = configBean;
        this.log = log;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT cc FROM ticket WHERE cc IS NOT NULL AND cc!=''";
    }

    @Override
    @Nullable
    public Collection<ExternalUser> transform(ResultSet rs) throws SQLException {
        String cc = rs.getString("cc");
        if (StringUtils.isEmpty((String)cc)) {
            return null;
        }
        ArrayList users = Lists.newArrayList();
        for (String email : cc.split(",")) {
            users.add(RequiredUserTransformer.transform(this.configBean, StringUtils.trimToEmpty((String)email), this.log));
        }
        return users;
    }
}

