/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac.config;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import com.atlassian.jira.plugins.importer.imports.trac.config.DropDownValueMapper;
import com.atlassian.jira.plugins.importer.imports.trac.config.PriorityToPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.trac.config.ResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.trac.config.SeverityToPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.trac.config.StatusValueMapper;
import com.atlassian.jira.plugins.importer.imports.trac.config.TypeValueMapper;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TracValueMappingDefinitionsFactory
implements ValueMappingDefinitionsFactory {
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsManager constantsManager;
    private final TracConfigBean configBean;
    private final FieldManager fieldManager;

    public TracValueMappingDefinitionsFactory(JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, TracConfigBean configBean, FieldManager fieldManager) {
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.configBean = configBean;
        this.fieldManager = fieldManager;
    }

    @Override
    public List<ValueMappingDefinition> createMappingDefinitions(ValueMappingHelper valueMappingHelper) {
        JdbcConnection jdbcConnection = this.configBean.getJdbcConnection();
        ArrayList mappings = Lists.newArrayList((Object[])new ValueMappingDefinition[]{new StatusValueMapper(jdbcConnection, this.authenticationContext, this.configBean), new ResolutionValueMapper(jdbcConnection, this.authenticationContext, this.constantsManager), new TypeValueMapper(jdbcConnection, this.authenticationContext, this.constantsManager)});
        for (ExternalCustomField customField : this.configBean.getCustomFields()) {
            String type = customField.getTypeKey();
            if ("severity".equals(customField.getId()) && this.configBean.isFieldMappedToIssueField("severity")) {
                mappings.add(new SeverityToPriorityValueMapper(jdbcConnection, this.authenticationContext, this.fieldManager, customField));
                continue;
            }
            if ("priority".equals(customField.getId()) && this.configBean.isFieldMappedToIssueField("priority")) {
                mappings.add(new PriorityToPriorityValueMapper(this.configBean, this.authenticationContext, this.fieldManager, customField));
                continue;
            }
            if (!"com.atlassian.jira.plugin.system.customfieldtypes:select".equals(type)) continue;
            if (customField.getValueMappingDefinition() != null) {
                mappings.add(customField.getValueMappingDefinition());
                continue;
            }
            mappings.add(new DropDownValueMapper(this.configBean, this.authenticationContext, customField));
        }
        return mappings;
    }
}

