/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac.config;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.AbstractPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.importer.SingleStringResultTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class SeverityToPriorityValueMapper
extends AbstractPriorityValueMapper {
    private final ExternalCustomField customField;

    public SeverityToPriorityValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext, FieldManager fieldManager, ExternalCustomField customField) {
        super(jdbcConnection, authenticationContext, fieldManager);
        this.customField = customField;
    }

    @Override
    public String getExternalFieldId() {
        return this.customField.getId();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.getI18n().getText("jira-importer-plugin.config.bugzilla.mappings.value.severity");
    }

    @Override
    public Set<String> getDistinctValues() {
        return new LinkedHashSet<String>(this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT DISTINCT severity FROM ticket WHERE severity!='' AND severity IS NOT NULL ORDER BY severity")));
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("blocker", 1), new ValueMappingEntry("critical", 2), new ValueMappingEntry("major", 3), new ValueMappingEntry("normal", 3), new ValueMappingEntry("minor", 4), new ValueMappingEntry("trivial", 5), new ValueMappingEntry("enhancement", 3)}).build();
    }
}

