/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import com.atlassian.jira.plugins.importer.imports.trac.TracWikiConverter;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.ActiveWatchersTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.AttachmentTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.ComponentTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.IssueTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.ProjectTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.RequiredUserTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.transformer.VersionTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TracDataBean
extends AbstractDataBean<TracConfigBean> {
    private final JdbcConnection jdbcConnection;
    public static final String ISSUE_KEY_REGEX = "(?:ticket:|#)([0-9]+)";
    private final TracWikiConverter wikiConverter;

    public TracDataBean(TracConfigBean configBean, TracWikiConverter wikiConverter) {
        super(configBean);
        this.wikiConverter = wikiConverter;
        this.jdbcConnection = configBean.getJdbcConnection();
    }

    @Override
    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    @Override
    public Set<ExternalUser> getAllUsers(ImportLogger log) {
        HashSet users = Sets.newHashSet(this.jdbcConnection.queryDb(new RequiredUserTransformer((TracConfigBean)this.configBean, log)));
        users.addAll(this.jdbcConnection.queryDbAppendCollection(new ActiveWatchersTransformer((TracConfigBean)this.configBean, log)));
        return users;
    }

    @Override
    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        return Sets.newHashSet((Iterable)Collections2.transform(((TracConfigBean)this.configBean).getExternalProjectNames(), (Function)new ProjectTransformer((AbstractDatabaseConfigBean)this.configBean)));
    }

    @Override
    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(new VersionTransformer((TracConfigBean)this.configBean, importLogger));
    }

    @Override
    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(new ComponentTransformer((TracConfigBean)this.configBean, importLogger));
    }

    @Override
    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(new IssueTransformer((TracConfigBean)this.configBean, importLogger, this.wikiConverter)).iterator();
    }

    @Override
    public Collection<ExternalLink> getLinks(ImportLogger log) {
        return Lists.newArrayList();
    }

    @Override
    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger log) {
        List<Long> count = this.jdbcConnection.queryDb(new ResultSetTransformer<Long>(){

            @Override
            public String getSqlQuery() {
                return "SELECT count(*) AS issues FROM ticket";
            }

            @Override
            public Long transform(ResultSet rs) throws SQLException {
                return rs.getLong("issues");
            }
        });
        return count.iterator().next();
    }

    @Override
    public String getUnusedUsersGroup() {
        return ((TracConfigBean)this.configBean).getUnusedUsersGroup();
    }

    @Override
    public void cleanUp() {
        this.jdbcConnection.closeConnection();
    }

    @Override
    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        String externalIssueOldId = externalIssue.getExternalId();
        return this.jdbcConnection.queryDb(new AttachmentTransformer((TracConfigBean)this.configBean, externalIssueOldId, log));
    }

    @Override
    public String getIssueKeyRegex() {
        return ISSUE_KEY_REGEX;
    }
}

