/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac;

import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.AbstractSelectFieldValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.SingleStringResultTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.TracImporterController;
import com.atlassian.jira.plugins.importer.imports.trac.config.TracValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;

public class TracConfigBean
extends AbstractDatabaseConfigBean {
    public static final String SEVERITY_FIELD = "severity";
    public static final String PRIORITY_FIELD = "priority";
    public static final String MILESTONE_FIELD = "milestone";
    private static final String UNUSED_USERS_GROUP = "trac-import-unused-users";
    private final Configuration environmentConfiguration;
    private final File environmentZip;
    private Long databaseVersion = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TracConfigBean(JdbcConnection jdbcConnection, File environmentZip) throws IOException, ConfigurationException {
        super(jdbcConnection);
        this.environmentZip = environmentZip;
        ZipFile zip = new ZipFile(environmentZip);
        try {
            this.environmentConfiguration = TracImporterController.getEnvironmentConfiguration(zip);
        }
        finally {
            zip.close();
        }
    }

    @Override
    public ValueMappingHelper initializeValueMappingHelper() {
        TracValueMappingDefinitionsFactory mappingDefinitionFactory = new TracValueMappingDefinitionsFactory(this.getJiraAuthenticationContext(), this.getConstantsManager(), this, this.getFieldManager());
        return new ValueMappingHelperImpl(mappingDefinitionFactory);
    }

    @Override
    public List<String> getExternalProjectNames() {
        return Lists.newArrayList((Object[])new String[]{StringUtils.defaultIfEmpty((String)this.environmentConfiguration.getString("descr"), (String)"Trac Project")});
    }

    @Override
    public Map<String, Map<String, String>> getAvailableFieldMappings(ExternalCustomField customField, Set<ExternalProject> projects) {
        LinkedHashMap fieldMappings = Maps.newLinkedHashMap();
        if (SEVERITY_FIELD.equals(customField.getId()) || PRIORITY_FIELD.equals(customField.getId())) {
            fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.issue.fields.header"), MapBuilder.newBuilder().add((Object)this.mapToIssueFieldValue(PRIORITY_FIELD), (Object)this.getI18nHelper().getText("issue.field.priority")).toMap());
        }
        fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.custom.fields.header"), this.getAvailableCustomFieldMappings(customField, projects));
        fieldMappings.putAll(super.getAvailableFieldMappings(customField, projects));
        return fieldMappings;
    }

    @Override
    public List<ExternalCustomField> getCustomFields() {
        ArrayList fields = Lists.newArrayList((Object[])new ExternalCustomField[]{ExternalCustomField.createSelect(SEVERITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.customfield.severity.name")), ExternalCustomField.createSelect(PRIORITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.customfield.priority.name")), ExternalCustomField.createSelect(MILESTONE_FIELD, this.getI18nHelper().getText("jira-importer-plugin.customfield.milestone.name"))});
        HashSet configKeys = Sets.newHashSet((Iterator)this.environmentConfiguration.getKeys());
        for (String key : configKeys) {
            String options;
            ExternalCustomField customField;
            if (!configKeys.contains(key + ".label")) continue;
            String label = this.environmentConfiguration.getString(key + ".label");
            String type = this.environmentConfiguration.getString(key);
            if ("textarea".equals(type)) {
                fields.add(ExternalCustomField.createFreeText(key, label));
                continue;
            }
            if ("checkbox".equals(type)) {
                fields.add(ExternalCustomField.createCheckboxes(key, label));
                continue;
            }
            if ("text".equals(type)) {
                fields.add(ExternalCustomField.createText(key, label));
                continue;
            }
            if ("select".equals(type)) {
                customField = ExternalCustomField.createSelect(key, label);
                customField.setValueMappingDefinition(new AbstractSelectFieldValueMapper(this, this.getJiraAuthenticationContext(), customField){

                    @Override
                    public Set<String> getDistinctValues() {
                        return Sets.newHashSet(this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT DISTINCT value FROM ticket_custom WHERE name='" + this.customField.getId() + "'")));
                    }
                });
                options = this.environmentConfiguration.getString(key + ".options");
                if (StringUtils.isNotBlank((String)options)) {
                    customField.setValueSet(Arrays.asList(StringUtils.split((String)options, (char)'|')));
                }
                fields.add(customField);
                continue;
            }
            if (!"radio".equals(type)) continue;
            customField = ExternalCustomField.createRadio(key, label);
            options = this.environmentConfiguration.getString(key + ".options");
            if (StringUtils.isNotBlank((String)options)) {
                customField.setValueSet(Arrays.asList(StringUtils.split((String)options, (char)'|')));
            }
            fields.add(customField);
        }
        return fields;
    }

    @Override
    public List<String> getLinkNamesFromDb() {
        return Lists.newArrayList();
    }

    public String getUsernameForEmail(@Nullable String email) {
        String translatedUserName = this.getValueMappingHelper().getValueMappingForImport("email", StringUtils.defaultIfEmpty((String)email, (String)"anonymous"));
        if (translatedUserName.equals(email)) {
            return TracConfigBean.extractUsername(email);
        }
        return translatedUserName;
    }

    @Nullable
    public static String extractFullName(String fullName) {
        if (StringUtils.contains((String)fullName, (String)"<") && StringUtils.contains((String)fullName, (String)">")) {
            return StringUtils.trimToNull((String)StringUtils.substringBefore((String)fullName, (String)"<"));
        }
        return null;
    }

    protected static String extractUsername(@Nullable String fullName) {
        String username = StringUtils.contains((String)fullName, (String)"<") && StringUtils.contains((String)fullName, (String)">") ? StringUtils.substringBetween((String)fullName, (String)"<", (String)">") : fullName;
        return StringUtils.defaultString((String)username, (String)"").toLowerCase(Locale.ENGLISH);
    }

    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }

    @Override
    public void populateFieldMappings(Map actionParams, ErrorCollection errors) {
        super.populateFieldMappings(actionParams, errors);
        if (((String)this.fieldMapping.get(SEVERITY_FIELD)).equals(this.fieldMapping.get(PRIORITY_FIELD))) {
            errors.addError(SEVERITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.config.mappings.duplicate.custom.fields", SEVERITY_FIELD, PRIORITY_FIELD));
            errors.addError(PRIORITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.config.mappings.duplicate.custom.fields", SEVERITY_FIELD, PRIORITY_FIELD));
        }
    }

    public File getEnvironmentZip() {
        return this.environmentZip;
    }

    @Nullable
    public Date getTimestamp(ResultSet rs, String column) throws SQLException {
        if (this.databaseVersion == null) {
            try {
                this.databaseVersion = Long.valueOf((String)Iterables.get(this.getJdbcConnection().queryDb(new SingleStringResultTransformer("SELECT value FROM system WHERE name='database_version'")), (int)0));
            }
            catch (Exception e) {
                this.databaseVersion = 1L;
            }
        }
        Long ts = rs.getLong(column);
        if (this.databaseVersion == null || this.databaseVersion < 25L) {
            return ts != null && ts != 0L ? new Date(ts * 1000L) : null;
        }
        return ts != null && ts != 0L ? new Date(ts / 1000L) : null;
    }
}

