/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal.web;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalSchemeManager;
import com.atlassian.jira.plugins.importer.managers.CreateProjectManager;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class PivotalProjectMappingsPage
extends ImporterProjectMappingsPage {
    private final PivotalSchemeManager pivotalSchemeManager;

    public PivotalProjectMappingsPage(UsageTrackingService usageTrackingService, @ComponentImport ProjectService projectService, PivotalSchemeManager pivotalSchemeManager, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, CreateProjectManager createProjectManager) {
        super(usageTrackingService, projectService, webInterfaceManager, pluginAccessor, projectManager, createProjectManager);
        this.pivotalSchemeManager = pivotalSchemeManager;
    }

    @Override
    protected void validateProject(String fieldId, ExternalProject project) {
        Project existingProject = this.getProjectManager().getProjectObjByKey(project.getKey());
        if (existingProject != null && !this.pivotalSchemeManager.isPTCompatible(existingProject)) {
            this.addError(fieldId, this.getText("jira-importer-plugin.pivotal.incompatibleSchema"));
        }
    }

    @Override
    protected void prepareComponents() {
        super.prepareComponents();
        Iterable compatibleProjects = Iterables.filter(this.mappingComponent.getApplicableProjects(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project input) {
                return PivotalProjectMappingsPage.this.pivotalSchemeManager.isPTCompatible(input);
            }
        });
        this.mappingComponent.setApplicableProjects((Collection<Project>)ImmutableList.copyOf((Iterable)compatibleProjects));
    }

    @Override
    public String getFormDescription() {
        return super.getFormDescription() + " " + this.getText("jira-importer-plugin.wizard.projectmappings.pivotal.additionalDescription");
    }
}

