/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;

public class ProjectMembershipParser {
    private final UserNameMapper userNameMapper;

    public ProjectMembershipParser(UserNameMapper userNameMapper) {
        this.userNameMapper = userNameMapper;
    }

    public ExternalUser parseUser(String projectId, Element element) {
        Element person = element.getChild("person");
        String email = person.getChildText("email");
        String name = this.userNameMapper.getUsernameForLoginName(person.getChildText("name"));
        ExternalUser externalUser = new ExternalUser(name.toLowerCase(Locale.ENGLISH), name, email);
        String role = element.getChildText("role");
        if (StringUtils.isNotBlank((String)role)) {
            externalUser.addRole(projectId, role);
        }
        return externalUser;
    }

    public List<ExternalUser> parseUsers(final String projectId, Element memberships) {
        return Lists.newArrayList((Iterable)Collections2.transform(XmlUtil.getChildren(memberships, "membership"), (Function)new Function<Element, ExternalUser>(){

            public ExternalUser apply(Element from) {
                return ProjectMembershipParser.this.parseUser(projectId, from);
            }
        }));
    }
}

