/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalRemoteException;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class PivotalTimeShiftsParser {
    private static final long UNITS_PER_HOUR = 3600L;
    private final String csv;
    private final UserNameMapper userNameMapper;

    public PivotalTimeShiftsParser(String csv, UserNameMapper userNameMapper) {
        this.csv = csv;
        this.userNameMapper = userNameMapper;
    }

    public List<ExternalWorklog> parseWorklog() throws IOException {
        CsvListReader reader = new CsvListReader((Reader)new StringReader(this.csv), new CsvPreference.Builder('\"', 44, "\n").surroundingSpacesNeedQuotes(true).build());
        List header = reader.read();
        this.verifyHeader(header);
        DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        ArrayList result = Lists.newArrayList();
        while (true) {
            ExternalWorklog worklogItem = new ExternalWorklog();
            List line = reader.read();
            if (line == null) break;
            Iterator lineIterator = line.iterator();
            try {
                String startDateString = (String)lineIterator.next();
                String userString1 = (String)lineIterator.next();
                String userString2 = (String)lineIterator.next();
                lineIterator.next();
                lineIterator.next();
                String timeSpentString = (String)lineIterator.next();
                String commentString = Strings.nullToEmpty((String)((String)lineIterator.next()));
                worklogItem.setStartDate(dateFormat.parseDateTime(startDateString).toDate());
                worklogItem.setAuthor(this.userNameMapper.getUsernameForLoginName(StringUtils.strip((String)(userString2 + " " + userString1))));
                worklogItem.setTimeSpent((long)(3600.0 * Double.parseDouble(timeSpentString)));
                worklogItem.setComment(commentString);
                result.add(worklogItem);
            }
            catch (NoSuchElementException e) {
                throw new PivotalRemoteException("Expecting line in CSV file with at least 7 columns", e);
            }
        }
        return result;
    }

    private void verifyHeader(Collection<String> header) {
        Validate.isTrue((header.size() >= 7 ? 1 : 0) != 0, (String)"Expecting CSV file with at least 7 columns");
        Iterable columns = Iterables.limit(header, (int)7);
        ImmutableList expectedColumns = ImmutableList.of((Object)"Date", (Object)"Last Name", (Object)"Given Name", (Object)"Person ID", (Object)"Project", (Object)"Hours", (Object)"Description");
        boolean columnsAsExpected = Iterables.elementsEqual((Iterable)columns, (Iterable)expectedColumns);
        Validate.isTrue((boolean)columnsAsExpected, (String)("Expecting CSV with following columns: " + expectedColumns + ", got " + columns));
    }
}

