/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.ManageableOptionType;
import com.atlassian.jira.web.action.admin.statuses.ViewStatuses;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PivotalSchemeManager {
    private static final String issueTypeSchemeName = "PT Issue Type Scheme";
    private static final String issueTypeSchemeDesc = "Issue Type Scheme used for projects imported from Pivotal Tracker";
    private static final String mainWorkflowName = "PT Workflow";
    private static final String subtaskWorkflowName = "PT Subtask Workflow";
    static final String mainWorkflowSource = "/pivotal/pt_workflow.xml";
    static final String subtaskWorkflowSource = "/pivotal/pt_subtask_workflow.xml";
    private static final String workflowSchemeName = "PT Workflow Scheme";
    private static final String workflowSchemeDescription = "Workflow Scheme for projects imported from Pivotal Tracker";
    static final String BUG = "Bug";
    static final String FEATURE = "New Feature";
    static final String CHORE = "Chore";
    static final String RELEASE = "Release";
    static final String SUBTASK = "Sub-task";
    private static final Map<String, String> defaultTypesAndIcons = ImmutableMap.of((Object)"Bug", (Object)"/images/icons/bug.gif", (Object)"New Feature", (Object)"/images/icons/newfeature.gif", (Object)"Chore", (Object)"/images/icons/task.gif", (Object)"Release", (Object)"/images/icons/requirement.gif", (Object)"Sub-task", (Object)"/images/icons/issue_subtask.gif");
    static final String ICE_BOX = "IceBox";
    static final String NOT_YET_STARTED = "Not Yet Started";
    static final String STARTED = "Started";
    static final String FINISHED = "Finished";
    static final String DELIVERED = "Delivered";
    static final String ACCEPTED = "Accepted";
    static final String REJECTED = "Rejected";
    private static final Map<String, String> pivotalStatuses = ImmutableMap.builder().put((Object)"IceBox", (Object)"/images/icons/status_generic.gif").put((Object)"Not Yet Started", (Object)"/images/icons/status_generic.gif").put((Object)"Started", (Object)"/images/icons/status_inprogress.gif").put((Object)"Finished", (Object)"/images/icons/status_resolved.gif").put((Object)"Delivered", (Object)"/images/icons/status_up.gif").put((Object)"Accepted", (Object)"/images/icons/status_closed.gif").put((Object)"Rejected", (Object)"/images/icons/status_reopened.gif").build();
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final FieldConfigSchemeManager configSchemeManager;
    private final ManageableOptionType manageableOptionType;
    private final FieldManager fieldManager;
    private final JiraContextTreeManager treeManager;
    private final WorkflowManager workflowManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final StatusManager statusManager;
    private final IssueTypeManager issueTypeManager;
    private final IssueManager issueManager;
    private Optional<Method> setStatusCategoryMethod = null;

    @Autowired
    public PivotalSchemeManager(@ComponentImport IssueTypeSchemeManager issueTypeSchemeManager, @ComponentImport SubTaskManager subTaskManager, @ComponentImport ConstantsManager constantsManager, @ComponentImport FieldConfigSchemeManager configSchemeManager, @ComponentImport FieldManager fieldManager, @ComponentImport WorkflowManager workflowManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport StatusManager statusManager, @ComponentImport IssueTypeManager issueTypeManager, @ComponentImport IssueManager issueManager) {
        this(issueTypeSchemeManager, subTaskManager, constantsManager, configSchemeManager, fieldManager, workflowManager, workflowSchemeManager, authenticationContext, (IssueTypeManageableOption)ComponentAccessor.getComponentOfType(IssueTypeManageableOption.class), (JiraContextTreeManager)ComponentAccessor.getComponentOfType(JiraContextTreeManager.class), statusManager, issueTypeManager, issueManager);
    }

    PivotalSchemeManager(IssueTypeSchemeManager issueTypeSchemeManager, SubTaskManager subTaskManager, ConstantsManager constantsManager, FieldConfigSchemeManager configSchemeManager, FieldManager fieldManager, WorkflowManager workflowManager, WorkflowSchemeManager workflowSchemeManager, JiraAuthenticationContext authenticationContext, IssueTypeManageableOption issueTypeManageableOption, JiraContextTreeManager jiraContextTreeManager, StatusManager statusManager, IssueTypeManager issueTypeManager, IssueManager issueManager) {
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
        this.configSchemeManager = configSchemeManager;
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
        this.workflowSchemeManager = workflowSchemeManager;
        this.manageableOptionType = issueTypeManageableOption;
        this.treeManager = jiraContextTreeManager;
        this.workflowManager = workflowManager;
        this.statusManager = statusManager;
        this.issueTypeManager = issueTypeManager;
        this.issueManager = issueManager;
    }

    public void setPTSchemesForProject(Project project) throws Exception {
        if (!this.subTaskManager.isSubTasksEnabled()) {
            try {
                this.subTaskManager.enableSubTasks();
            }
            catch (CreateException e) {
                throw new RuntimeException("Cannot enable subtasks", e);
            }
        }
        List<String> issueTypeIds = this.createIssueTypes();
        this.assignPTIssueTypeScheme(project, issueTypeIds);
        this.assignPTWorkflowScheme(project);
    }

    protected List<String> createIssueTypes() {
        ArrayList options = Lists.newArrayListWithCapacity((int)defaultTypesAndIcons.size());
        for (String issueTypeName : defaultTypesAndIcons.keySet()) {
            IssueConstant issueConstant = this.constantsManager.getIssueConstantByName("IssueType", issueTypeName);
            if (issueConstant != null) {
                options.add(issueConstant.getId());
                continue;
            }
            String icon = defaultTypesAndIcons.get(issueTypeName);
            IssueType issueType = issueTypeName.equals(SUBTASK) ? this.issueTypeManager.createSubTaskIssueType(issueTypeName, "", icon) : this.issueTypeManager.createIssueType(issueTypeName, "", icon);
            options.add(issueType.getId());
        }
        return options;
    }

    void assignPTIssueTypeScheme(Project project, List<String> issueTypeIds) {
        FieldConfigScheme ptScheme = this.getPTScheme(issueTypeIds);
        List associatedProjectObjects = ptScheme.getAssociatedProjectObjects();
        ArrayList projectIds = Lists.newArrayList((Iterable)Iterables.transform((Iterable)associatedProjectObjects, (Function)new Function<Project, Long>(){

            public Long apply(@Nullable Project input) {
                return input.getId();
            }
        }));
        Long[] allPTProjects = (Long[])ArrayUtils.add((Object[])projectIds.toArray(new Long[projectIds.size()]), (Object)project.getId());
        List context = CustomFieldUtils.buildJiraIssueContexts((boolean)false, null, (Long[])allPTProjects, (JiraContextTreeManager)this.treeManager);
        ConfigurableField field = this.fieldManager.getConfigurableField(this.manageableOptionType.getFieldId());
        this.configSchemeManager.updateFieldConfigScheme(ptScheme, context, field);
        this.fieldManager.refresh();
    }

    FieldConfigScheme getPTScheme(List<String> issueTypeIds) {
        List allSchemas = this.issueTypeSchemeManager.getAllSchemes();
        for (FieldConfigScheme scheme : allSchemas) {
            if (!issueTypeSchemeName.equals(scheme.getName())) continue;
            return scheme;
        }
        FieldConfigScheme scheme = this.issueTypeSchemeManager.create(issueTypeSchemeName, issueTypeSchemeDesc, issueTypeIds);
        this.issueTypeSchemeManager.setDefaultValue(scheme.getOneAndOnlyConfig(), String.valueOf(2));
        return scheme;
    }

    void assignPTWorkflowScheme(Project project) {
        this.workflowSchemeManager.removeSchemesFromProject(project);
        this.workflowSchemeManager.addSchemeToProject(project, this.getPTWorkflowScheme());
    }

    Scheme getPTWorkflowScheme() {
        Scheme existingScheme = this.workflowSchemeManager.getSchemeObject(workflowSchemeName);
        if (existingScheme != null) {
            return existingScheme;
        }
        JiraWorkflow ptWorkflow = this.getPTWorkflow(mainWorkflowName, mainWorkflowSource);
        JiraWorkflow ptSubtaskWorkflow = this.getPTWorkflow(subtaskWorkflowName, subtaskWorkflowSource);
        try {
            Scheme scheme = this.workflowSchemeManager.createSchemeObject(workflowSchemeName, workflowSchemeDescription);
            GenericValue schemeGV = this.workflowSchemeManager.getScheme(scheme.getId());
            String subtaskId = this.constantsManager.getIssueConstantByName("IssueType", SUBTASK).getId();
            this.workflowSchemeManager.addWorkflowToScheme(schemeGV, ptSubtaskWorkflow.getName(), subtaskId);
            this.workflowSchemeManager.addWorkflowToScheme(schemeGV, ptWorkflow.getName(), "0");
            return scheme;
        }
        catch (GenericEntityException e) {
            throw new RuntimeException("Error creating workflow scheme for projects imported from Pivotal Tracker", e);
        }
    }

    JiraWorkflow getPTWorkflow(String workflowName, String workflowSource) {
        JiraWorkflow workflow;
        JiraWorkflow jiraWorkflow = workflow = this.workflowManager.workflowExists(workflowName) ? this.workflowManager.getWorkflow(workflowName) : null;
        if (workflow != null) {
            return workflow;
        }
        this.loadPTWorkflow(workflowName, workflowSource);
        return this.workflowManager.getWorkflow(workflowName);
    }

    void loadPTWorkflow(String workflowName, String workflowSource) {
        WorkflowDescriptor workflowDescriptor;
        Map<String, String> nameToIdMapping = this.getPTStatusNameToIdMapping();
        try {
            String substitutedXml = this.substituteStatusIds(this.getClass().getResourceAsStream(workflowSource), nameToIdMapping);
            workflowDescriptor = WorkflowLoader.load((InputStream)IOUtils.toInputStream((String)substitutedXml), (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating workflow for projects imported from Pivotal Tracker", e);
        }
        ConfigurableJiraWorkflow newWorkflow = new ConfigurableJiraWorkflow(workflowName, workflowDescriptor, this.workflowManager);
        this.workflowManager.createWorkflow(this.authenticationContext.getUser(), (JiraWorkflow)newWorkflow);
    }

    String substituteStatusIds(InputStream input, Map<String, String> mapping) throws JDOMException, IOException, JaxenException {
        Document document = XmlUtil.getSAXBuilder().build(input);
        Element rootElement = document.getRootElement();
        List statusIdNodes = new JDOMXPath("//step/meta[@name='jira.status.id'][. >= 10000]").selectNodes((Object)rootElement);
        for (Element statusNode : statusIdNodes) {
            String name = statusNode.getParentElement().getAttributeValue("name");
            String mappedId = mapping.get(name);
            statusNode.setText(mappedId);
        }
        return new XMLOutputter(Format.getRawFormat()).outputString(document);
    }

    Map<String, String> getPTStatusNameToIdMapping() {
        HashMap mapping = Maps.newHashMapWithExpectedSize((int)pivotalStatuses.size());
        for (String statusName : pivotalStatuses.keySet()) {
            Status statusByName = this.constantsManager.getStatusByName(statusName);
            if (statusByName == null) {
                String result;
                ViewStatuses vs = new ViewStatuses(null, this.statusManager, this.workflowManager){

                    protected String redirectToView() {
                        return "success";
                    }
                };
                vs.setIconurl(pivotalStatuses.get(statusName));
                vs.setName(statusName);
                String description = MessageFormat.format("Mapping for {0} in Pivotal Tracker", statusName);
                vs.setDescription(description);
                try {
                    this.setStatusCategoryIfPossible(vs, 1L);
                    result = vs.doAddStatus();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error adding status " + statusName, e);
                }
                if ("error".equals(result)) {
                    String errorMessage = Joiner.on((String)", ").join((Iterable)vs.getErrorMessages());
                    throw new RuntimeException(String.format("Error adding status %s. Errors: %s", statusName, errorMessage));
                }
                statusByName = this.constantsManager.getStatusByName(statusName);
            }
            mapping.put(statusName, statusByName.getId());
        }
        return mapping;
    }

    private void setStatusCategoryIfPossible(ViewStatuses viewStatuses, Long statusCategoryId) throws InvocationTargetException, IllegalAccessException {
        Optional<Method> statusCategoryMethod = this.getStatusCategoryMethod();
        if (statusCategoryMethod.isPresent()) {
            ((Method)statusCategoryMethod.get()).invoke((Object)viewStatuses, statusCategoryId);
        }
    }

    private Optional<Method> getStatusCategoryMethod() {
        if (this.setStatusCategoryMethod == null) {
            try {
                this.setStatusCategoryMethod = Optional.of((Object)ViewStatuses.class.getMethod("setStatusCategory", Long.class));
            }
            catch (NoSuchMethodException e) {
                this.setStatusCategoryMethod = Optional.absent();
            }
        }
        return this.setStatusCategoryMethod;
    }

    public boolean isPTCompatible(Project project) {
        if (this.issueManager.getIssueCountForProject(project.getId()) <= 0L) {
            return true;
        }
        Set<String> ptStatusNames = PivotalSchemeManager.getRegisteredStatusNames();
        JiraWorkflow workflow = this.workflowManager.getWorkflow(project.getId(), "0");
        HashSet linkedStatusNames = Sets.newHashSet((Iterable)Iterables.transform((Iterable)workflow.getLinkedStatusObjects(), (Function)new Function<Status, String>(){

            public String apply(Status input) {
                return input.getName();
            }
        }));
        return linkedStatusNames.containsAll(ptStatusNames);
    }

    static Set<String> getRegisteredStatusNames() {
        return pivotalStatuses.keySet();
    }
}

