/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.NamedExternalObject;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class PivotalIteration
implements NamedExternalObject {
    private final String id;
    private final List<ExternalIssue> issues;
    private final DateTime start;
    private final DateTime finish;
    private static final DateTimeFormatter NAME_DATE_FORMAT = DateTimeFormat.forPattern((String)"d MMM");

    public PivotalIteration(String id, DateTime start, DateTime finish, List<ExternalIssue> issues) {
        this.finish = finish;
        this.start = start;
        this.id = id;
        this.issues = ImmutableList.copyOf(issues);
    }

    public PivotalIteration(PivotalIteration iteration) {
        this.id = iteration.id;
        this.start = iteration.start;
        this.finish = iteration.finish;
        this.issues = ImmutableList.copyOf((Collection)Collections2.transform(iteration.issues, (Function)new Function<ExternalIssue, ExternalIssue>(){

            public ExternalIssue apply(ExternalIssue input) {
                return new ExternalIssue(input);
            }
        }));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.getId() + " : " + this.getStart().toString(NAME_DATE_FORMAT);
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getFinish() {
        return this.finish;
    }

    public List<ExternalIssue> getStories() {
        return this.issues;
    }
}

