/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.pivotal.CachingPivotalClient;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalClient;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalConfigBean;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalDataBean;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalHttpException;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalRemoteException;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalSchemeManager;
import com.atlassian.jira.plugins.importer.imports.pivotal.web.PivotalProjectMappingsPage;
import com.atlassian.jira.plugins.importer.imports.pivotal.web.PivotalSetupPage;
import com.atlassian.jira.plugins.importer.imports.pivotal.web.PivotalUserMappingsPage;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.RemoteSiteImporterSetupPage;
import com.atlassian.jira.plugins.importer.web.RemoteSiteValidator;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class PivotalImporterController
extends AbstractImporterController {
    private final PivotalSchemeManager pivotalSchemeManager;
    private final JimJiraSoftwareAccessor jimJiraSoftwareAccessor;
    private final I18nHelper i18nHelper;
    private final ConfigFileHandler configFileHandler;
    private final Logger logger = Logger.getLogger(PivotalImporterController.class);
    public static final String PIVOTAL_IMPORT_CONFIG_BEAN = "issue.importer.jira.pivotal.import.bean";

    public PivotalImporterController(JiraDataImporter pivotalImporter, PivotalSchemeManager pivotalSchemeManager, JimJiraSoftwareAccessor jimJiraSoftwareAccessor, ConfigFileHandler configFileHandler, @ComponentImport JiraAuthenticationContext authenticationContext) {
        super(pivotalImporter, PIVOTAL_IMPORT_CONFIG_BEAN, "Pivotal");
        this.pivotalSchemeManager = pivotalSchemeManager;
        this.jimJiraSoftwareAccessor = jimJiraSoftwareAccessor;
        this.i18nHelper = authenticationContext.getI18nHelper();
        this.configFileHandler = configFileHandler;
    }

    @Override
    public boolean createImportProcessBean(AbstractSetupPage setupPage) {
        PivotalSetupPage pivotalSetupPage = (PivotalSetupPage)setupPage;
        this.validateRemoteSiteConnection(pivotalSetupPage);
        if (pivotalSetupPage.invalidInput()) {
            return false;
        }
        SiteConfiguration siteConfiguration = new SiteConfiguration(pivotalSetupPage.getSiteUrl(), pivotalSetupPage.getSiteCredentials(), pivotalSetupPage.getSiteUsername(), pivotalSetupPage.getSitePassword());
        ImportProcessBean importProcessBean = new ImportProcessBean();
        importProcessBean.setUrlBean(siteConfiguration);
        PivotalConfigBean configBean = new PivotalConfigBean(siteConfiguration, this);
        configBean.setShowUserMappingPage(pivotalSetupPage.isShowUsernameMapping());
        if (!this.configFileHandler.populateFromConfigFile(pivotalSetupPage, configBean)) {
            return false;
        }
        importProcessBean.setConfigBean(configBean);
        this.storeImportProcessBeanInSession(importProcessBean);
        return true;
    }

    @Override
    public PivotalDataBean createDataBean() {
        return this.createDataBean(true);
    }

    public PivotalDataBean createDataBean(boolean mapUserNames) {
        PivotalConfigBean configBean = this.getConfigBeanFromSession();
        return new PivotalDataBean(configBean, this.pivotalSchemeManager, PivotalImporterController.isTimeTrackingOn(), this.jimJiraSoftwareAccessor, mapUserNames);
    }

    @Nullable
    PivotalConfigBean getConfigBeanFromSession() {
        ImportProcessBean importProcessBean = this.getImportProcessBeanFromSession();
        return importProcessBean != null ? (PivotalConfigBean)importProcessBean.getConfigBean() : null;
    }

    public void validateRemoteSiteConnection(RemoteSiteImporterSetupPage importerSetupPage) {
        if (new RemoteSiteValidator().validateConnection(importerSetupPage)) {
            try {
                URI pivotalURI = new URI(importerSetupPage.getSiteUrl());
                CachingPivotalClient pivotalClient = new CachingPivotalClient(pivotalURI, UserNameMapper.NO_MAPPING);
                pivotalClient.login(importerSetupPage.getSiteUsername(), importerSetupPage.getSitePassword());
                ((PivotalClient)pivotalClient).logout();
            }
            catch (PivotalHttpException e) {
                if (e.getStatusLine().getStatusCode() == 401) {
                    importerSetupPage.addErrorMessage(this.i18nHelper.getText("jira-importer-plugin.external.pivotal.login.invalid.credentials"));
                    this.logger.info((Object)"Problem while authenticating to Pivotal Tracker site", (Throwable)e);
                } else {
                    importerSetupPage.addErrorMessage("Cannot login to Pivotal Tracker site: " + e.getMessage());
                    this.logger.info((Object)"Cannot login to Pivotal Tracker site", (Throwable)e);
                }
            }
            catch (PivotalRemoteException e) {
                importerSetupPage.addErrorMessage("Cannot login to Pivotal Tracker site: " + e.getMessage());
                this.logger.info((Object)"Cannot login to Pivotal Tracker site", (Throwable)e);
            }
            catch (URISyntaxException e) {
                importerSetupPage.addErrorMessage("Cannot login to Pivotal Tracker site: " + e.getMessage());
                this.logger.info((Object)"Cannot login to Pivotal Tracker site", (Throwable)e);
            }
        }
    }

    @Override
    public List<String> getSteps() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new String[]{PivotalSetupPage.class.getSimpleName(), PivotalProjectMappingsPage.class.getSimpleName()});
        PivotalConfigBean config = this.getConfigBeanFromSession();
        if (config != null && config.isShowUserMappingPage()) {
            builder.add((Object)PivotalUserMappingsPage.class.getSimpleName());
        }
        return builder.build();
    }

    @Override
    public List<String> getStepNameKeys() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new String[]{"jira-importer-plugin.wizard.step.PivotalSetupPage", "jira-importer-plugin.wizard.step.PivotalProjectMappingsPage"});
        PivotalConfigBean config = this.getConfigBeanFromSession();
        if (config != null && config.isShowUserMappingPage()) {
            builder.add((Object)"jira-importer-plugin.wizard.step.PivotalUserMappingsPage");
        }
        return builder.build();
    }

    @Override
    public boolean isUsingConfiguration() {
        return true;
    }

    private static boolean isTimeTrackingOn() {
        return ComponentAccessor.getFieldManager().isTimeTrackingOn();
    }
}

