/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.pivotal.CachingPivotalClient;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalClient;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalConfigBean;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalIteration;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalRemoteException;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalSchemeManager;
import com.atlassian.jira.plugins.importer.sample.Callbacks;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.DefaultedMap;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import webwork.action.ActionContext;

public class PivotalDataBean
extends AbstractDataBean<PivotalConfigBean> {
    private static final String UNUSED_USERS_GROUP = "pivotal-import-unused-users";
    private final PivotalClient pivotalClient;
    private final Map<Long, String> rapidBoards = Maps.newHashMap();
    private final PivotalSchemeManager pivotalSchemeManager;
    private final JimJiraSoftwareAccessor jimJiraSoftwareAccessor;
    private final boolean importTimeTracking;
    private final Map<String, String> issueTypeMapping;
    private final Map<String, String> statusMapping;
    private final Set<String> statusNeedsResolution = ImmutableSet.of((Object)"Accepted", (Object)"Closed");
    private final Map<String, String> roleMapping = DefaultedMap.decorate((Map)ImmutableMap.of((Object)"Owner", (Object)"Administrators", (Object)"Member", (Object)"Developers", (Object)"Viewer", (Object)"Users"), (Object)"Developers");

    public PivotalDataBean(PivotalConfigBean configBean, PivotalSchemeManager pivotalSchemeManager, boolean importTimeTracking, JimJiraSoftwareAccessor jimJiraSoftwareAccessor, boolean mapUserNames) {
        super(configBean);
        this.pivotalClient = mapUserNames ? configBean.getPivotalClient() : new CachingPivotalClient(URI.create(configBean.getCredentials().getUrl()), UserNameMapper.NO_MAPPING);
        this.pivotalSchemeManager = pivotalSchemeManager;
        this.importTimeTracking = importTimeTracking;
        this.jimJiraSoftwareAccessor = jimJiraSoftwareAccessor;
        this.issueTypeMapping = DefaultedMap.decorate((Map)new CaseInsensitiveMap((Map)new ImmutableMap.Builder().put((Object)"bug", (Object)"Bug").put((Object)"chore", (Object)"Chore").put((Object)"feature", (Object)"New Feature").put((Object)"release", (Object)"Release").put((Object)"subtask", (Object)"Sub-task").build()), (Object)"Bug");
        this.statusMapping = DefaultedMap.decorate((Map)new CaseInsensitiveMap((Map)new ImmutableMap.Builder().put((Object)"delivered", (Object)"Delivered").put((Object)"finished", (Object)"Finished").put((Object)"started", (Object)"Started").put((Object)"rejected", (Object)"Rejected").put((Object)"accepted", (Object)"Accepted").put((Object)"subtask_open", (Object)"Open").put((Object)"subtask_finished", (Object)"Closed").build()), (Object)"IceBox");
    }

    public PivotalClient getPivotalClient() throws PivotalRemoteException {
        if (!this.pivotalClient.isLoggedIn()) {
            this.pivotalClient.login(((PivotalConfigBean)this.configBean).getCredentials().getUsername(), ((PivotalConfigBean)this.configBean).getCredentials().getPassword());
        }
        return this.pivotalClient;
    }

    @Override
    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        HashSet users = Sets.newHashSet();
        for (ExternalProject project : projects) {
            try {
                List<ExternalUser> members = this.getPivotalClient().getMembers(project.getId(), importLogger);
                this.translateProjectRoles(members);
                users.addAll(members);
            }
            catch (PivotalRemoteException e) {
                throw new RuntimeException(e);
            }
        }
        return users;
    }

    @Override
    public Set<ExternalUser> getAllUsers(ImportLogger log) {
        return this.getRequiredUsers(this.getSelectedProjects(log), log);
    }

    @Override
    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        try {
            HashSet externalProjects = Sets.newHashSet(this.getPivotalClient().getAllProjects(log));
            for (ExternalProject externalProject : externalProjects) {
                String externalProjectName = externalProject.getExternalName();
                externalProject.setKey(this.getProjectKey(this.configBean, externalProjectName));
                externalProject.setName(((PivotalConfigBean)this.configBean).getProjectName(externalProjectName));
            }
            return externalProjects;
        }
        catch (PivotalRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getProjectKey(AbstractConfigBean2 configBean, String projectName) {
        String projectKey = configBean.getProjectKey(projectName);
        if (projectKey != null) {
            return projectKey;
        }
        return null;
    }

    @Override
    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        try {
            List<PivotalIteration> iterations = this.getPivotalClient().getIterations(externalProject.getId(), importLogger);
            return Collections2.transform(iterations, (Function)new Function<PivotalIteration, ExternalVersion>(){

                public ExternalVersion apply(PivotalIteration input) {
                    ExternalVersion version = new ExternalVersion();
                    version.setId(input.getId());
                    version.setName(input.getName());
                    DateTime finish = input.getFinish();
                    version.setReleaseDate(finish);
                    version.setReleased(finish.isBefore((ReadableInstant)new DateTime().toDateMidnight().toInstant()));
                    return version;
                }
            });
        }
        catch (PivotalRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return Collections.emptyList();
    }

    public Iterable<ExternalIssue> getIssues(ExternalProject externalProject, ImportLogger importLogger) {
        try {
            List<ExternalIssue> stories = this.getPivotalClient().getStories(externalProject.getId(), importLogger);
            Map<String, String> issuesPerIteration = this.indexIssuesToIterations(externalProject, stories.size(), importLogger);
            ImmutableMap name2id = ImmutableMap.builder().putAll(this.pivotalSchemeManager.getPTStatusNameToIdMapping()).put((Object)"Open", (Object)String.valueOf(1)).put((Object)"Closed", (Object)String.valueOf(6)).build();
            CustomField rankingField = ((PivotalConfigBean)this.configBean).getCustomFieldNameForRanking();
            String searcherType = rankingField != null && rankingField.getCustomFieldSearcher() != null ? rankingField.getCustomFieldSearcher().getDescriptor().getCompleteKey() : null;
            for (ExternalIssue story : stories) {
                if (rankingField != null) {
                    ExternalCustomFieldValue ranking = new ExternalCustomFieldValue(rankingField.getName(), rankingField.getCustomFieldType().getKey(), searcherType, null);
                    story.addExternalCustomFieldValue(ranking);
                }
                this.translateSingle(story, (Map<String, String>)name2id);
                if (issuesPerIteration.containsKey(story.getExternalId())) {
                    story.setFixedVersions(Collections.singletonList(issuesPerIteration.get(story.getExternalId())));
                }
                for (ExternalIssue subtask : story.getSubtasks()) {
                    this.translateSingle(subtask, (Map<String, String>)name2id);
                    subtask.setFixedVersions(story.getFixedVersions());
                }
            }
            return this.importTimeTracking ? Iterables.concat(stories, this.createIssueForTimeTracking(externalProject, importLogger)) : stories;
        }
        catch (PivotalRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<ExternalIssue> createIssueForTimeTracking(ExternalProject externalProject, ImportLogger importLogger) throws PivotalRemoteException {
        List<ExternalWorklog> worklog;
        try {
            worklog = this.getPivotalClient().getWorklog(Long.parseLong(externalProject.getId()), importLogger);
        }
        catch (IOException e) {
            importLogger.fail(e, "Error downloading time tracking information", new Object[0]);
            return Collections.emptyList();
        }
        if (worklog.isEmpty()) {
            importLogger.log("No time tracking information found for project %s", externalProject.getName());
            return Collections.emptyList();
        }
        ExternalIssue timeTrackingHolder = new ExternalIssue();
        timeTrackingHolder.setSummary("Placeholder for imported time tracking data");
        timeTrackingHolder.setDescription("Pivotal Tracker provides time tracking information on the project level.\nJIRA stores time tracking information on issue level, so this issue has been created to store imported time tracking information.");
        timeTrackingHolder.setIssueType("Chore");
        timeTrackingHolder.setWorklogs(worklog);
        return Collections.singletonList(timeTrackingHolder);
    }

    private Map<String, String> indexIssuesToIterations(ExternalProject externalProject, int expectedSize, ImportLogger importLogger) throws PivotalRemoteException {
        HashMap issuesPerIteration = Maps.newHashMapWithExpectedSize((int)expectedSize);
        for (PivotalIteration pi : this.getPivotalClient().getIterations(externalProject.getId(), importLogger)) {
            for (ExternalIssue story : pi.getStories()) {
                issuesPerIteration.put(story.getExternalId(), pi.getName());
            }
        }
        return issuesPerIteration;
    }

    private void translateSingle(ExternalIssue story, Map<String, String> name2id) {
        String status = this.statusMapping.get(story.getStatus());
        if (this.statusNeedsResolution.contains(status)) {
            story.setResolution(((PivotalConfigBean)this.configBean).getDefaultResolutionId());
        }
        story.setStatus(name2id.get(status));
        story.setIssueType(this.issueTypeMapping.get(story.getIssueType()));
    }

    private void translateProjectRoles(Collection<ExternalUser> externalUsers) {
        for (ExternalUser externalUser : externalUsers) {
            HashMultimap transformedProjectRoles = HashMultimap.create((Multimap)Multimaps.transformValues(externalUser.getProjectRoles(), (Function)new Function<String, String>(){

                public String apply(String input) {
                    return (String)PivotalDataBean.this.roleMapping.get(input);
                }
            }));
            externalUser.setProjectRoles((Multimap<String, String>)transformedProjectRoles);
        }
    }

    @Override
    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        return this.getIssues(externalProject, importLogger).iterator();
    }

    @Override
    public Collection<ExternalLink> getLinks(ImportLogger log) {
        return Collections.emptyList();
    }

    @Override
    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger log) {
        int total = 0;
        for (ExternalProject selectedProject : selectedProjects) {
            total += Iterables.size(this.getIssues(selectedProject, log));
        }
        return total;
    }

    @Override
    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }

    @Override
    public void cleanUp() {
        try {
            this.getPivotalClient().logout();
        }
        catch (PivotalRemoteException pivotalRemoteException) {
            // empty catch block
        }
    }

    @Override
    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        try {
            return this.getPivotalClient().getAttachmentsForIssue(externalIssue, log);
        }
        catch (PivotalRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public String getIssueKeyRegex() {
        return null;
    }

    @Override
    public Callbacks getCallbacks() {
        return new Callbacks(){

            @Override
            public void afterProjectCreated(ExternalProject project, Project jiraProject, boolean newProject) {
                try {
                    PivotalDataBean.this.pivotalSchemeManager.setPTSchemesForProject(jiraProject);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error setting up Pivotal scheme for project " + project.getKey(), e);
                }
                if (PivotalDataBean.this.jimJiraSoftwareAccessor.isGreenHooperFeaturesEnabled()) {
                    try {
                        Pair<Long, String> view = PivotalDataBean.this.jimJiraSoftwareAccessor.createRapidBoard(jiraProject);
                        if (view != null) {
                            PivotalDataBean.this.rapidBoards.put(view.first(), view.second());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error setting up Pivotal Rapid Board for project " + project.getKey(), e);
                    }
                }
            }
        };
    }

    @Override
    public String getExternalSystemUrl() {
        return ((PivotalConfigBean)this.configBean).getCredentials().getUrl();
    }

    @Override
    public String getReturnLinks() {
        if (this.rapidBoards.isEmpty()) {
            return super.getReturnLinks();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<div id=\"rapidBoardLinks\">").append(((PivotalConfigBean)this.configBean).getI18nHelper().getText("jira-importer-plugin.PivotalDataBean.take.me"));
        for (Map.Entry<Long, String> view : this.rapidBoards.entrySet()) {
            sb.append("<span><a href=\"").append(ActionContext.getContext().getRequestImpl().getContextPath()).append("/secure/RapidBoard.jspa?rapidView=").append(view.getKey()).append("\">").append(view.getValue()).append("</a></span>");
        }
        sb.append("</div>");
        return sb.toString();
    }
}

