/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.plugins.importer.Immutables;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalClient;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalIteration;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalRemoteException;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class CachingPivotalClient
extends PivotalClient {
    private final Map<String, List<ExternalIssue>> storiesCache = Maps.newHashMap();
    private final Map<String, List<PivotalIteration>> iterationsCache = Maps.newHashMap();
    private final Map<String, List<ExternalUser>> membersCache = Maps.newHashMap();
    private List<ExternalProject> externalProjects;
    private List<String> externalProjectNames;

    CachingPivotalClient(URI uri) {
        super(uri);
    }

    public CachingPivotalClient(URI uri, UserNameMapper userNameMapper) {
        super(uri, userNameMapper);
    }

    @Override
    public List<String> getAllProjectNames() throws PivotalRemoteException {
        if (this.externalProjectNames == null) {
            this.externalProjectNames = super.getAllProjectNames();
        }
        return this.externalProjectNames;
    }

    @Override
    public List<ExternalProject> getAllProjects(ImportLogger log) throws PivotalRemoteException {
        if (this.externalProjects == null) {
            this.externalProjects = super.getAllProjects(log);
        }
        return Lists.transform(this.externalProjects, (Function)new Function<ExternalProject, ExternalProject>(){

            public ExternalProject apply(ExternalProject input) {
                return input.getClone();
            }
        });
    }

    @Override
    public List<ExternalIssue> getStories(String projectId, ImportLogger importLogger) throws PivotalRemoteException {
        List<ExternalIssue> result = this.storiesCache.get(projectId);
        if (result == null) {
            result = super.getStories(projectId, importLogger);
            this.storiesCache.put(projectId, result);
        }
        return Immutables.transformThenCopyToList(result, new Function<ExternalIssue, ExternalIssue>(){

            public ExternalIssue apply(ExternalIssue input) {
                return new ExternalIssue(input);
            }
        });
    }

    @Override
    public List<PivotalIteration> getIterations(String projectId, ImportLogger importLogger) throws PivotalRemoteException {
        List<PivotalIteration> result = this.iterationsCache.get(projectId);
        if (result == null) {
            result = super.getIterations(projectId, importLogger);
            this.iterationsCache.put(projectId, result);
        }
        return Lists.transform(result, (Function)new Function<PivotalIteration, PivotalIteration>(){

            public PivotalIteration apply(PivotalIteration input) {
                return new PivotalIteration(input);
            }
        });
    }

    @Override
    public List<ExternalUser> getMembers(String projectId, ImportLogger importLogger) throws PivotalRemoteException {
        List<ExternalUser> result = this.membersCache.get(projectId);
        if (result == null) {
            result = super.getMembers(projectId, importLogger);
            this.membersCache.put(projectId, result);
        }
        return Lists.transform(result, (Function)new Function<ExternalUser, ExternalUser>(){

            public ExternalUser apply(ExternalUser input) {
                return new ExternalUser(input);
            }
        });
    }

    @Override
    public void logout() {
        super.logout();
        this.externalProjects = null;
        this.membersCache.clear();
        this.storiesCache.clear();
    }
}

