/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import java.sql.ResultSet;
import java.sql.SQLException;

public class VersionTransformer
extends AbstractResultSetTransformer<ExternalVersion> {
    private final ExternalProject externalProject;
    private MantisConfigBean.TimestampHelper timestampHelper = new MantisConfigBean.TimestampHelper();

    public VersionTransformer(ExternalProject externalProject, ImportLogger importLogger) {
        super(importLogger);
        this.externalProject = externalProject;
    }

    @Override
    public String getSqlQuery() {
        return String.format("SELECT * FROM mantis_project_version_table WHERE version IS NOT NULL AND version != '' AND  (project_id = %s OR version IN (SELECT version FROM mantis_bug_table WHERE project_id=%s) OR version IN (SELECT fixed_in_version FROM mantis_bug_table WHERE project_id=%s))", this.externalProject.getId(), this.externalProject.getId(), this.externalProject.getId());
    }

    @Override
    public ExternalVersion transform(ResultSet rs) throws SQLException {
        ExternalVersion version = new ExternalVersion(rs.getString("version"));
        version.setReleaseDate(this.timestampHelper.getTimestamp(rs, "date_order"));
        version.setDescription(rs.getString("description"));
        version.setReleased(rs.getBoolean("released"));
        if (SqlUtils.getColumnNames(rs.getMetaData()).contains("obsolete") && rs.getBoolean("obsolete")) {
            version.setArchived(true);
        }
        return version;
    }
}

