/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.customfields.converters.DateTimePickerConverter;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.AbstractIssueTransformer;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.SingleStringResultTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisFieldConstants;
import com.atlassian.jira.plugins.importer.imports.mantis.config.MultipleSelectionValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.CommentTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.WatchersTransformer;
import com.atlassian.jira.util.RegexpUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class IssueTransformerVer118OrOlder
extends AbstractIssueTransformer<MantisConfigBean> {
    protected final ExternalProject externalProject;
    private final String mantisUrl;
    private final DateTimePickerConverter dateTimePicker;
    private MantisConfigBean.TimestampHelper timestampHelper;

    public IssueTransformerVer118OrOlder(String mantisUrl, MantisConfigBean configBean, ExternalProject externalProject, DateTimePickerConverter dateTimePicker, ImportLogger importLogger) {
        super(configBean, importLogger);
        this.mantisUrl = mantisUrl;
        this.timestampHelper = new MantisConfigBean.TimestampHelper();
        this.dateTimePicker = dateTimePicker;
        this.externalProject = externalProject;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT *, (SELECT username FROM mantis_user_table p WHERE p.id=b.reporter_id) reporter_name,(SELECT username FROM mantis_user_table p WHERE p.id=b.handler_id) assignee_name FROM mantis_bug_table b LEFT OUTER JOIN mantis_bug_text_table t ON (b.bug_text_id=t.id) WHERE project_id=" + this.externalProject.getId() + " ORDER BY date_submitted";
    }

    @Override
    public ExternalIssue transform(ResultSet rs) throws SQLException {
        String fixFor;
        String version;
        String summary = rs.getString("summary");
        if (StringUtils.isEmpty((String)summary)) {
            this.log.warn("Summary is blank and is not imported", new Object[0]);
            return null;
        }
        String oldId = rs.getString("id");
        ExternalIssue externalIssue = new ExternalIssue();
        externalIssue.setExternalId(oldId);
        externalIssue.setSummary(IssueTransformerVer118OrOlder.escapeMantisString(summary));
        externalIssue.setDescription(IssueTransformerVer118OrOlder.escapeMantisString(rs.getString("description")));
        externalIssue.setEnvironment(this.getEnvironment(rs));
        String category = rs.getString("category");
        if (StringUtils.isNotBlank((String)category)) {
            externalIssue.setComponents(Collections.singleton(category));
        }
        if (StringUtils.isNotBlank((String)(version = rs.getString("version")))) {
            externalIssue.setAffectedVersions(Collections.singleton(version));
        }
        if (StringUtils.isNotBlank((String)(fixFor = rs.getString("fixed_in_version")))) {
            externalIssue.setFixedVersions(Collections.singleton(fixFor));
        }
        externalIssue.setReporter(((MantisConfigBean)this.configBean).getUsernameForLoginName(rs.getString("reporter_name")));
        externalIssue.setAssignee(((MantisConfigBean)this.configBean).getUsernameForLoginName(rs.getString("assignee_name")));
        externalIssue.setCreated(this.timestampHelper.getTimestamp(rs, "date_submitted"));
        externalIssue.setLabels(((MantisConfigBean)this.configBean).getJdbcConnection().queryDb(new SingleStringResultTransformer("SELECT name FROM mantis_tag_table AS t INNER JOIN mantis_bug_tag_table AS bt ON (t.id=bt.tag_id) WHERE bug_id=" + oldId)));
        Date closed = this.timestampHelper.getTimestamp(rs, "last_updated");
        Date resolved = this.timestampHelper.getTimestamp(rs, "last_updated");
        externalIssue.setResolutionDate(resolved);
        if (closed != null && resolved == null) {
            externalIssue.setUpdated(closed);
        } else if (closed == null && resolved != null) {
            externalIssue.setUpdated(resolved);
        } else if (closed != null) {
            if (closed.after(resolved)) {
                externalIssue.setUpdated(closed);
            } else {
                externalIssue.setUpdated(resolved);
            }
        }
        this.setCustomFieldValues(externalIssue, rs, oldId);
        this.mapStatusAndResolution(rs, externalIssue);
        this.mapIssueType(rs, externalIssue);
        CommentTransformer commentTransformer = new CommentTransformer(oldId, (MantisConfigBean)this.configBean);
        List<ExternalComment> comments = ((MantisConfigBean)this.configBean).getJdbcConnection().queryDb(commentTransformer);
        externalIssue.setComments(comments);
        WatchersTransformer watchersTransformer = new WatchersTransformer(oldId, (MantisConfigBean)this.configBean);
        externalIssue.setWatchers(((MantisConfigBean)this.configBean).getJdbcConnection().queryDb(watchersTransformer));
        return externalIssue;
    }

    private void mapIssueType(ResultSet rs, ExternalIssue externalIssue) throws SQLException {
        ValueMappingHelper valueMappingHelper = ((MantisConfigBean)this.configBean).getValueMappingHelper();
        String issueType = valueMappingHelper.getValueMappingForImport("severity as issue type", MantisFieldConstants.getSeverityName(rs.getString("severity")));
        externalIssue.setIssueType(issueType);
    }

    private void mapStatusAndResolution(ResultSet rs, ExternalIssue externalIssue) throws SQLException {
        ValueMappingHelper valueMappingHelper = ((MantisConfigBean)this.configBean).getValueMappingHelper();
        String status = valueMappingHelper.getValueMappingForImport("status", MantisFieldConstants.getStatusName(rs.getString("status")));
        externalIssue.setStatus(status);
        StatusManager statusManager = (StatusManager)ComponentAccessor.getComponent(StatusManager.class);
        Status statusObject = statusManager.getStatus(status);
        if (statusObject != null && statusObject.getStatusCategory().getKey().equals("done")) {
            externalIssue.setResolution(valueMappingHelper.getValueMappingForImport("resolution", MantisFieldConstants.getResolutionName(rs.getString("resolution"))));
        }
    }

    protected String getEnvironment(ResultSet rs) throws SQLException {
        String os = rs.getString("os");
        String platform = rs.getString("platform");
        StringBuilder environment = new StringBuilder();
        if (StringUtils.isNotBlank((String)os)) {
            environment.append("Operating System: ").append(os).append("\n");
        }
        if (StringUtils.isNotBlank((String)platform)) {
            environment.append("Platform: ").append(platform);
        }
        return environment.toString();
    }

    @Nonnull
    public static String escapeMantisString(@Nullable String str) {
        String newString = RegexpUtils.replaceAll((String)StringUtils.defaultString((String)str), (String)"<a (?:target=\"_new\" )?href=['\"](?:mailto:)?(.*?)['\"](?: target=\"_new\")?>.*</a>", (String)"$1");
        newString = RegexpUtils.replaceAll((String)newString, (String)"&quot;", (String)"\"");
        newString = RegexpUtils.replaceAll((String)newString, (String)"&lt;", (String)"<");
        newString = RegexpUtils.replaceAll((String)newString, (String)"&gt;", (String)">");
        newString = RegexpUtils.replaceAll((String)newString, (String)"&amp;", (String)">");
        return newString;
    }

    @Override
    @Nullable
    protected Object getCustomFieldValue(ResultSet rs, String bugId, ExternalCustomField customField) throws SQLException {
        if ("bug_url".equals(customField.getId())) {
            return this.mantisUrl + (this.mantisUrl.endsWith("/") ? "" : "/") + "view.php?id=" + bugId;
        }
        String cfTypeKey = customField.getTypeKey();
        if (StringUtils.isNumeric((String)customField.getId())) {
            List<String> dbValue = this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT value FROM mantis_custom_field_string_table WHERE field_id=" + customField.getId() + " AND bug_id=" + bugId));
            if (dbValue.size() == 1 && StringUtils.isNotBlank((String)dbValue.get(0))) {
                if ("com.atlassian.jira.plugin.system.customfieldtypes:multiselect".equals(cfTypeKey) || "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes".equals(cfTypeKey)) {
                    return this.getMappedValues(customField, dbValue.get(0));
                }
                if ("com.atlassian.jira.plugin.system.customfieldtypes:select".equals(cfTypeKey)) {
                    return ((MantisConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport(customField.getName(), dbValue.get(0));
                }
                if ("com.atlassian.jira.plugin.system.customfieldtypes:datetime".equals(cfTypeKey)) {
                    return this.dateTimePicker.getString(new Date(Long.valueOf(dbValue.get(0)) * 1000L));
                }
                return ((MantisConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport(customField.getName(), dbValue.get(0));
            }
        } else {
            String dbValue = rs.getString(customField.getId());
            if ("priority".equals(customField.getId())) {
                dbValue = MantisFieldConstants.getPriorityName(dbValue);
            }
            if ("severity".equals(customField.getId())) {
                dbValue = MantisFieldConstants.getSeverityName(dbValue);
            }
            return IssueTransformerVer118OrOlder.escapeMantisString(((MantisConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport(customField.getId(), dbValue));
        }
        return null;
    }

    private Collection<String> getMappedValues(final ExternalCustomField customField, String s) {
        return Lists.transform(MultipleSelectionValueMapper.getValues(s), (Function)new Function<String, String>(){

            public String apply(@Nonnull String from) {
                return ((MantisConfigBean)IssueTransformerVer118OrOlder.this.configBean).getValueMappingHelper().getValueMappingForImport(customField.getName(), from);
            }
        });
    }
}

