/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.issue.customfields.converters.DateTimePickerConverter;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.IssueTransformerVer118OrOlder;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.IssueTransformerVer120OrNewer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class IssueTransformerFactory {
    private static final Logger log = Logger.getLogger(IssueTransformerFactory.class);
    private static final String META_COLUMN_NAME = "COLUMN_NAME";
    private static final String TABLE_NAME = "mantis_bug_table";
    private static final String CATEGORY_ID_COLUMN = "category_id";
    final boolean hasCategoryId;

    public IssueTransformerFactory(JdbcConnection jdbcConnection) {
        this.hasCategoryId = this.checkForCategoryId(jdbcConnection);
    }

    public ResultSetTransformer<ExternalIssue> create(String mantisUrl, MantisConfigBean configBean, ExternalProject project, DateTimePickerConverter dateTimePickerConverter, ImportLogger log) {
        if (!this.hasCategoryId) {
            return new IssueTransformerVer118OrOlder(mantisUrl, configBean, project, dateTimePickerConverter, log);
        }
        return new IssueTransformerVer120OrNewer(mantisUrl, configBean, project, dateTimePickerConverter, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForCategoryId(JdbcConnection jdbcConnection) {
        Connection connection = null;
        try {
            connection = jdbcConnection.getConnection();
            boolean bl = this.hasCategoryIdColumn(connection);
            return bl;
        }
        catch (SQLException e) {
            log.info((Object)"Assuming Mantis is version 1.2.0 or higher");
            log.warn((Object)"Error getting the column name data from database", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCategoryIdColumn(Connection connection) throws SQLException {
        log.debug((Object)"Getting the column names of the 'mantis_bug_table' table");
        ResultSet columns = connection.getMetaData().getColumns(null, null, TABLE_NAME, null);
        try {
            while (columns.next()) {
                String columnName = columns.getString(META_COLUMN_NAME);
                if (!CATEGORY_ID_COLUMN.equals(columnName)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"'mantis_bug_table' table contains column 'category_id'");
                    log.debug((Object)"Assuming Mantis newer than 1.2.0");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (columns != null) {
                columns.close();
            }
        }
    }
}

