/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class ComponentTransformerVer120OrNewer
extends AbstractResultSetTransformer<ExternalComponent> {
    private final MantisConfigBean configBean;
    private final ExternalProject externalProject;

    public ComponentTransformerVer120OrNewer(MantisConfigBean configBean, ExternalProject externalProject, ImportLogger importLogger) {
        super(importLogger);
        this.configBean = configBean;
        this.externalProject = externalProject;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT name,(SELECT username FROM mantis_user_table WHERE id=c.user_id) AS username FROM mantis_category_table AS c WHERE project_id=" + this.externalProject.getId() + " OR (EXISTS(SELECT 1 FROM mantis_project_table WHERE id=" + this.externalProject.getId() + " AND inherit_global=1) AND c.project_id=0)";
    }

    @Override
    public ExternalComponent transform(ResultSet rs) throws SQLException {
        String componentName = rs.getString("name");
        if (StringUtils.isBlank((String)componentName)) {
            return null;
        }
        return new ExternalComponent(componentName, null, this.configBean.getUsernameForLoginName(rs.getString("username")), null);
    }
}

