/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.ComponentTransformerVer118OrOlder;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.ComponentTransformerVer120OrNewer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ComponentTransformerFactory {
    private static final Logger log = Logger.getLogger(ComponentTransformerFactory.class);
    private static final String TABLE_NAME = "mantis_category_table";
    final boolean hasNewTable;

    public ComponentTransformerFactory(JdbcConnection jdbcConnection) {
        this.hasNewTable = this.checkForNewTable(jdbcConnection);
    }

    public ResultSetTransformer<ExternalComponent> create(MantisConfigBean configBean, ExternalProject externalProject, ImportLogger importLogger) {
        if (!this.hasNewTable) {
            return new ComponentTransformerVer118OrOlder(configBean, externalProject, importLogger);
        }
        return new ComponentTransformerVer120OrNewer(configBean, externalProject, importLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForNewTable(JdbcConnection jdbcConnection) {
        Connection connection = null;
        try {
            connection = jdbcConnection.getConnection();
            boolean bl = SqlUtils.hasTable(connection, TABLE_NAME);
            return bl;
        }
        catch (SQLException e) {
            log.info((Object)"Assuming Mantis is version lower than 1.2.0");
            log.warn((Object)"Error checking table for mantis_category_table", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
    }
}

