/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.IssueTransformerVer118OrOlder;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class CommentTransformer
implements ResultSetTransformer<ExternalComment> {
    private final String ixBug;
    private final MantisConfigBean configBean;
    private MantisConfigBean.TimestampHelper timestampHelper;

    public CommentTransformer(String ixBug, MantisConfigBean configBean) {
        this.ixBug = ixBug;
        this.configBean = configBean;
        this.timestampHelper = new MantisConfigBean.TimestampHelper();
    }

    @Override
    public String getSqlQuery() {
        return "SELECT note, (SELECT username FROM mantis_user_table WHERE id=b.reporter_id) AS username, date_submitted FROM mantis_bugnote_table AS b JOIN mantis_bugnote_text_table AS bt ON (b.bugnote_text_id=bt.id) WHERE bug_id = " + this.ixBug + " ORDER BY date_submitted ASC";
    }

    @Override
    public ExternalComment transform(ResultSet rs) throws SQLException {
        String commenter = this.configBean.getUsernameForLoginName(rs.getString("username"));
        String comment = IssueTransformerVer118OrOlder.escapeMantisString(rs.getString("note"));
        if (StringUtils.isNotBlank((String)comment)) {
            return new ExternalComment(comment, commenter, this.timestampHelper.getTimestamp(rs, "date_submitted"));
        }
        return null;
    }
}

