/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.config;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.AbstractResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisFieldConstants;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class ResolutionValueMapper
extends AbstractResolutionValueMapper {
    public static final String FIELD = "resolution";

    public ResolutionValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager) {
        super(jdbcConnection, authenticationContext, constantsManager);
    }

    @Override
    public String getExternalFieldId() {
        return FIELD;
    }

    @Override
    public String getDescription() {
        return this.getI18n().getText("jira-importer-plugin.config.bugzilla.mappings.value.resolution");
    }

    @Override
    protected String getSqlQuery() {
        return "SELECT DISTINCT resolution FROM mantis_bug_table";
    }

    @Override
    public String transformResolution(String resolution) {
        return MantisFieldConstants.getResolutionName(resolution);
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("fixed", 1), new ValueMappingEntry("unable to reproduce", 5), new ValueMappingEntry("not fixable", 2), new ValueMappingEntry("duplicate", 3), new ValueMappingEntry("no change required", ""), new ValueMappingEntry("suspended", ""), new ValueMappingEntry("won't fix", 2)}).build();
    }
}

