/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.config;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.AbstractPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisFieldConstants;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

public class PriorityToPriorityValueMapper
extends AbstractPriorityValueMapper {
    private final AbstractDatabaseConfigBean configBean;
    private final ExternalCustomField customField;

    public PriorityToPriorityValueMapper(AbstractDatabaseConfigBean configBean, JiraAuthenticationContext authenticationContext, FieldManager fieldManager, ExternalCustomField customField) {
        super(configBean.getJdbcConnection(), authenticationContext, fieldManager);
        this.configBean = configBean;
        this.customField = customField;
    }

    @Override
    public String getExternalFieldId() {
        return this.customField.getId();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.getI18n().getText("jira-importer-plugin.config.mapped.to.issue.field", this.customField.getName(), this.configBean.getIssueFieldMapping(this.customField.getId()));
    }

    @Override
    public Set<String> getDistinctValues() {
        return Sets.newTreeSet(this.jdbcConnection.queryDb(new PriorityTransformer()));
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("immediate", 1), new ValueMappingEntry("urgent", 2), new ValueMappingEntry("high", 3), new ValueMappingEntry("normal", 4), new ValueMappingEntry("low", 4), new ValueMappingEntry("none", 5)}).build();
    }

    static class PriorityTransformer
    implements ResultSetTransformer<String> {
        PriorityTransformer() {
        }

        @Override
        public String getSqlQuery() {
            return "SELECT DISTINCT priority FROM mantis_bug_table ORDER BY priority";
        }

        @Override
        public String transform(ResultSet rs) throws SQLException {
            return MantisFieldConstants.getPriorityName(rs.getString(1));
        }
    }
}

