/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.config;

import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.config.AbstractValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class MultipleSelectionValueMapper
extends AbstractValueMappingDefinition {
    private final AbstractDatabaseConfigBean configBean;
    private final ExternalCustomField customField;
    private static final char VALUE_SEPARATOR = '|';

    protected MultipleSelectionValueMapper(AbstractDatabaseConfigBean configBean, JiraAuthenticationContext authenticationContext, ExternalCustomField customField) {
        super(configBean.getJdbcConnection(), authenticationContext);
        this.configBean = configBean;
        this.customField = customField;
    }

    @Override
    public String getExternalFieldId() {
        return this.customField.getName();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.getI18n().getText("jira-importer-plugin.config.mapped.to.custom.field", this.customField.getName(), this.configBean.getFieldMapping(this.customField.getId()));
    }

    @Override
    public Set<String> getDistinctValues() {
        return Sets.newHashSet(this.jdbcConnection.queryDbAppendCollection(new ResultSetTransformer<Collection<String>>(){

            @Override
            public String getSqlQuery() {
                return "SELECT DISTINCT value FROM mantis_custom_field_string_table WHERE field_id=" + MultipleSelectionValueMapper.this.customField.getId();
            }

            @Override
            public Collection<String> transform(ResultSet rs) throws SQLException {
                String value = TextUtils.noNull((String)rs.getString("value"));
                return Sets.newHashSet((Iterable)Iterables.filter(MultipleSelectionValueMapper.getValues(value), (Predicate)new Predicate<String>(){

                    public boolean apply(@Nullable String input) {
                        return StringUtils.isNotBlank((String)input);
                    }
                }));
            }
        }));
    }

    public static List<String> getValues(String value) {
        return Arrays.asList(StringUtils.split((String)value, (char)'|'));
    }
}

