/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.customfields.converters.DateTimePickerConverter;
import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.AttachmentTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.ComponentTransformerFactory;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.IssueTransformerFactory;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.LinksTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.NoAuthorAttachmentTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.ProjectTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.RequiredUserTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.UserTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.VersionTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MantisDataBean
extends AbstractDataBean<MantisConfigBean> {
    private final JdbcConnection jdbcConnection;
    private final SiteConfiguration mantisUrl;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    public static final String ISSUE_KEY_REGEX = "(?:bug)?#([0-9 ,]+)";
    private final ComponentTransformerFactory componentTransformerFactory;
    private final IssueTransformerFactory issueTransformerFactory;
    private final boolean attachmentsHasAuthor;

    public MantisDataBean(JdbcConnection jdbcConnection, MantisConfigBean configBean, SiteConfiguration urlBean, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(configBean);
        this.jdbcConnection = jdbcConnection;
        this.mantisUrl = urlBean;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.componentTransformerFactory = new ComponentTransformerFactory(jdbcConnection);
        this.issueTransformerFactory = new IssueTransformerFactory(jdbcConnection);
        this.attachmentsHasAuthor = this.isAuthorColumnInAttachments(jdbcConnection);
    }

    private boolean isAuthorColumnInAttachments(JdbcConnection jdbcConnection) {
        try {
            List<String> columns = SqlUtils.getColumnNames(jdbcConnection.getConnection(), "mantis_bug_file_table");
            return columns.contains("user_id");
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger log) {
        return new HashSet<ExternalUser>(this.jdbcConnection.queryDb(new RequiredUserTransformer((MantisConfigBean)this.configBean, projects, log)));
    }

    @Override
    public Set<ExternalUser> getAllUsers(ImportLogger log) {
        return new HashSet<ExternalUser>(this.jdbcConnection.queryDb(new UserTransformer((MantisConfigBean)this.configBean, log)));
    }

    @Override
    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        return Sets.newHashSet(this.jdbcConnection.queryDb(new ProjectTransformer((MantisConfigBean)this.configBean, log)));
    }

    @Override
    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(new VersionTransformer(externalProject, importLogger));
    }

    @Override
    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(this.componentTransformerFactory.create((MantisConfigBean)this.configBean, externalProject, importLogger));
    }

    @Override
    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        return this.jdbcConnection.queryDb(this.issueTransformerFactory.create(this.mantisUrl.getUrl(), (MantisConfigBean)this.configBean, externalProject, new DateTimePickerConverter(this.dateTimeFormatterFactory), importLogger)).iterator();
    }

    @Override
    public Collection<ExternalLink> getLinks(ImportLogger log) {
        Set<ExternalProject> selectedProjects = this.getSelectedProjects(log);
        Iterable projectIds = Iterables.transform(selectedProjects, (Function)new Function<ExternalProject, String>(){

            public String apply(ExternalProject input) {
                return input.getId();
            }
        });
        return this.jdbcConnection.queryDb(new LinksTransformer((MantisConfigBean)this.configBean, projectIds));
    }

    @Override
    public long getTotalIssues(final Set<ExternalProject> selectedProjects, ImportLogger log) {
        List<Long> count = this.jdbcConnection.queryDb(new ResultSetTransformer<Long>(){

            @Override
            public String getSqlQuery() {
                return "SELECT count(*) AS issues FROM mantis_bug_table WHERE project_id IN (" + SqlUtils.comma(selectedProjects) + ")";
            }

            @Override
            public Long transform(ResultSet rs) throws SQLException {
                return rs.getLong("issues");
            }
        });
        return count.iterator().next();
    }

    @Override
    public String getUnusedUsersGroup() {
        return ((MantisConfigBean)this.configBean).getUnusedUsersGroup();
    }

    @Override
    public void cleanUp() {
        this.jdbcConnection.closeConnection();
    }

    @Override
    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        String externalIssueOldId = externalIssue.getExternalId();
        if (this.attachmentsHasAuthor) {
            return this.jdbcConnection.queryDb(new AttachmentTransformer((MantisConfigBean)this.configBean, externalIssueOldId, this.mantisUrl, log));
        }
        return this.jdbcConnection.queryDb(new NoAuthorAttachmentTransformer((MantisConfigBean)this.configBean, externalIssueOldId, this.mantisUrl, log));
    }

    @Override
    public String getIssueKeyRegex() {
        return ISSUE_KEY_REGEX;
    }

    @Override
    public String getExternalSystemUrl() {
        return this.mantisUrl.getUrl();
    }
}

