/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ConsoleImportLogger;
import com.atlassian.jira.plugins.importer.imports.mantis.config.MantisValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.CustomFieldTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.ProjectTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class MantisConfigBean
extends AbstractDatabaseConfigBean {
    public static final String RELATED_TO_LINK_NAME = "Related to";
    public static final String DUPLICATE_LINK_NAME = "Duplicate of / Has duplicate";
    public static final String PARENT_LINK_NAME = "Parent of / Child of";
    private static final String INACTIVE_USERS_GROUP = "mantis-import-disabled-users";
    private static final String UNUSED_USERS_GROUP = "mantis-import-unused-users";
    public static final String SEVERITY_FIELD = "severity";
    public static final String PRIORITY_FIELD = "priority";

    public MantisConfigBean(JdbcConnection jdbcConnection) {
        super(jdbcConnection);
    }

    @Override
    public ValueMappingHelper initializeValueMappingHelper() {
        return new ValueMappingHelperImpl(new MantisValueMappingDefinitionsFactory(this.getJiraAuthenticationContext(), this.getConstantsManager(), this, this.getFieldManager()));
    }

    @Override
    public List<String> getExternalProjectNames() {
        return this.getJdbcConnection().queryDb(new ResultSetTransformer<String>(){

            @Override
            public String getSqlQuery() {
                return new ProjectTransformer(MantisConfigBean.this, ConsoleImportLogger.INSTANCE).getSqlQuery();
            }

            @Override
            public String transform(ResultSet rs) throws SQLException {
                return rs.getString("name");
            }
        });
    }

    @Override
    public List<ExternalCustomField> getCustomFields() {
        ArrayList fields = Lists.newArrayList((Object[])new ExternalCustomField[]{new ExternalCustomField("bug_url", "External issue URL", "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher"), ExternalCustomField.createFreeText("steps_to_reproduce", this.getI18nHelper().getText("jira-importer-plugin.external.mantis.steps_to_reproduce")), ExternalCustomField.createFreeText("additional_information", this.getI18nHelper().getText("jira-importer-plugin.external.mantis.additional_information")), ExternalCustomField.createSelect(SEVERITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.customfield.severity.name")), ExternalCustomField.createSelect(PRIORITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.customfield.priority.name"))});
        fields.addAll(this.jdbcConnection.queryDb(new CustomFieldTransformer()));
        return fields;
    }

    @Override
    public List<String> getLinkNamesFromDb() {
        return Lists.newArrayList((Object[])new String[]{RELATED_TO_LINK_NAME, DUPLICATE_LINK_NAME, PARENT_LINK_NAME});
    }

    @Nullable
    public String getUsernameForLoginName(@Nullable String loginName) {
        if (loginName == null) {
            return null;
        }
        return this.getValueMappingHelper().getValueMappingForImport("username", loginName);
    }

    public String getInactiveUsersGroup() {
        return INACTIVE_USERS_GROUP;
    }

    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }

    @Override
    public Map<String, Map<String, String>> getAvailableFieldMappings(ExternalCustomField customField, Set<ExternalProject> projects) {
        LinkedHashMap fieldMappings = Maps.newLinkedHashMap();
        if (SEVERITY_FIELD.equals(customField.getId()) || PRIORITY_FIELD.equals(customField.getId())) {
            fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.issue.fields.header"), MapBuilder.newBuilder().add((Object)this.mapToIssueFieldValue(PRIORITY_FIELD), (Object)this.getI18nHelper().getText("issue.field.priority")).toMap());
        }
        fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.custom.fields.header"), this.getAvailableCustomFieldMappings(customField, projects));
        fieldMappings.putAll(super.getAvailableFieldMappings(customField, projects));
        return fieldMappings;
    }

    @Override
    public void populateFieldMappings(Map actionParams, ErrorCollection errors) {
        super.populateFieldMappings(actionParams, errors);
        if (((String)this.fieldMapping.get(SEVERITY_FIELD)).equals(this.fieldMapping.get(PRIORITY_FIELD))) {
            errors.addError(SEVERITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.config.mappings.duplicate.custom.fields", SEVERITY_FIELD, PRIORITY_FIELD));
            errors.addError(PRIORITY_FIELD, this.getI18nHelper().getText("jira-importer-plugin.config.mappings.duplicate.custom.fields", SEVERITY_FIELD, PRIORITY_FIELD));
        }
    }

    public static class TimestampHelper {
        private final Map<String, Boolean> columnIsTimestamp = Maps.newHashMap();

        @Nullable
        public Date getTimestamp(ResultSet rs, String column) throws SQLException {
            if (!this.columnIsTimestamp.containsKey(column)) {
                List<String> columns = SqlUtils.getColumnNames(rs.getMetaData());
                int idx = columns.indexOf(column) + 1;
                int type = rs.getMetaData().getColumnType(idx);
                this.columnIsTimestamp.put(column, type == 93 || type == 92 || type == 91);
            }
            if (this.columnIsTimestamp.get(column).booleanValue()) {
                return rs.getTimestamp(column);
            }
            Date result = new Date(rs.getLong(column) * 1000L);
            return rs.wasNull() ? null : result;
        }
    }
}

