/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.json.web;

import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class JsonSetupPage
extends AbstractSetupPage {
    public static final String FILE_INPUT_NAME = "jsonFile";
    private final TemporaryAttachmentsMonitorLocator locator;
    private String filetoconvert;
    private TemporaryAttachment tempAttachment;

    public JsonSetupPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TemporaryAttachmentsMonitorLocator locator) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.locator = locator;
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (this.isPreviousClicked()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.getFiletoconvert()) || !NumberUtils.isNumber((String)this.getFiletoconvert())) {
            this.addError(FILE_INPUT_NAME, this.getText("jira-importer-plugin.csv.setup.page.file.is.empty"));
            return;
        }
        this.tempAttachment = this.locator.get(true).getById(Long.valueOf(this.getFiletoconvert()));
        if (this.tempAttachment == null) {
            this.addError(FILE_INPUT_NAME, this.getText("jira-importer-plugin.csv.setup.page.file.is.empty"));
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        this.publishImporterWizardStartedEvent();
        if (!this.isPreviousClicked() && !controller.createImportProcessBean(this)) {
            return "input";
        }
        return super.doExecute();
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.JsonSetupPage.form.title");
    }

    @Override
    public String getFormDescription() {
        return this.getText("jira-import-plugin.you.can.generate.json");
    }

    public String getFiletoconvert() {
        return this.filetoconvert;
    }

    public void setFiletoconvert(String filetoconvert) {
        this.filetoconvert = filetoconvert;
    }

    public TemporaryAttachment getTempAttachment() {
        return this.tempAttachment;
    }
}

