/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.project.Project;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

public class ExistingCustomFieldsPredicate
implements Predicate<CustomField> {
    private final ExternalCustomField externalCustomField;
    private final Set<ExternalProject> projects;
    private final boolean checkNameMatching;

    public ExistingCustomFieldsPredicate(ExternalCustomField externalCustomField, Collection<ExternalProject> projects) {
        this.externalCustomField = externalCustomField;
        this.projects = Sets.newHashSet(projects);
        this.checkNameMatching = true;
    }

    public ExistingCustomFieldsPredicate(ExternalCustomField externalCustomField, Set<ExternalProject> projects, boolean checkNameMatching) {
        this.externalCustomField = externalCustomField;
        this.projects = projects;
        this.checkNameMatching = checkNameMatching;
    }

    public boolean apply(@Nullable CustomField existingCustomField) {
        if (existingCustomField == null) {
            return false;
        }
        return !(this.checkNameMatching && !this.isTheSameName(existingCustomField) || !this.isTheSameType(existingCustomField) && !this.isTextFieldToTextArea(existingCustomField) || !this.isValidForProjects(existingCustomField));
    }

    private boolean isTheSameName(CustomField existingCustomField) {
        return existingCustomField.getName().equals(this.externalCustomField.getName()) || existingCustomField.getId().equals(this.externalCustomField.getName());
    }

    private boolean isValidForProjects(CustomField existingCustomField) {
        return existingCustomField.isAllProjects() || this.isInScopeForProjects(existingCustomField);
    }

    private boolean isTextFieldToTextArea(CustomField existingCustomField) {
        return this.externalCustomField.getTypeKey().equals("com.atlassian.jira.plugin.system.customfieldtypes:textfield") && existingCustomField.getCustomFieldType().getKey().equals("com.atlassian.jira.plugin.system.customfieldtypes:textarea");
    }

    private boolean isTheSameType(CustomField input) {
        return input.getCustomFieldType().getKey().equals(this.externalCustomField.getTypeKey());
    }

    protected boolean isInScopeForProjects(CustomField customField) {
        final ImmutableSet projectIdsInScope = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)customField.getAssociatedProjectObjects(), (Function)new Function<Project, Long>(){

            public Long apply(Project input) {
                return input.getId();
            }
        }));
        return Iterables.all(this.projects, (Predicate)new Predicate<ExternalProject>(){

            public boolean apply(ExternalProject project) {
                return project.getJiraId() != null && projectIdsInScope.contains((Object)project.getJiraId());
            }
        });
    }
}

