/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.external.ExternalException;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterOptions;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CustomFieldValueFactory;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.ExistingCustomFieldsPredicate;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldsUtil {
    private static final String DEFAULT_CF_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:textfield";
    private static final String CREATED_CF_DESCRIPTION = "%s created by JIM during import process";
    private final CustomFieldManager customFieldManager;
    private final FieldScreenManager fieldScreenManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FieldConfigManager fieldConfigManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final OptionsManager optionsManager;
    private final CustomFieldValueFactory customFieldValueFactory;
    private final CompatibilityBridgeUtils bridgeUtils;
    private final JimJiraSoftwareAccessor jimJiraSoftwareAccessor;

    @Autowired
    public CustomFieldsUtil(@ComponentImport CustomFieldManager customFieldManager, @ComponentImport FieldScreenManager fieldScreenManager, @ComponentImport ManagedConfigurationItemService managedConfigurationItemService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport FieldConfigManager fieldConfigManager, @ComponentImport FieldConfigSchemeManager fieldConfigSchemeManager, @ComponentImport OptionsManager optionsManager, CompatibilityBridgeUtils bridgeUtils, CustomFieldValueFactory customFieldValueFactory, JimJiraSoftwareAccessor jimJiraSoftwareAccessor) {
        this.customFieldManager = customFieldManager;
        this.fieldScreenManager = fieldScreenManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldConfigManager = fieldConfigManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.optionsManager = optionsManager;
        this.customFieldValueFactory = customFieldValueFactory;
        this.bridgeUtils = bridgeUtils;
        this.jimJiraSoftwareAccessor = jimJiraSoftwareAccessor;
    }

    public Optional<CustomField> getExistingCustomField(ExternalCustomField customField, Set<ExternalProject> projects) {
        Iterable matchingFields = Iterables.filter((Iterable)this.customFieldManager.getCustomFieldObjects(), (Predicate)new ExistingCustomFieldsPredicate(customField, projects));
        return Optional.fromNullable((Object)Iterables.getFirst((Iterable)matchingFields, null));
    }

    public CustomField createNewCustomField(ExternalCustomField customField, Set<ExternalProject> projects) throws ExternalException {
        CustomField createdCustomField;
        CustomFieldType cfType = this.getCFType(customField);
        CustomFieldSearcher cfSearcher = this.getSearcher(customField, cfType);
        String name = customField.getName();
        String description = String.format(CREATED_CF_DESCRIPTION, name);
        Iterable projectContexts = Iterables.transform(projects, (Function)new Function<ExternalProject, JiraContextNode>(){

            public ProjectContext apply(ExternalProject input) {
                return new ProjectContext(input.getJiraId());
            }
        });
        try {
            ArrayList issueTypes = Lists.newArrayList((Object[])new IssueType[]{null});
            createdCustomField = this.customFieldManager.createCustomField(name, description, cfType, cfSearcher, (List)ImmutableList.copyOf((Iterable)projectContexts), (List)issueTypes);
        }
        catch (GenericEntityException e) {
            throw new ExternalException(e);
        }
        this.associateCustomFieldWithDefaultScreen(createdCustomField);
        this.addOptions(createdCustomField, customField.getValueSet(), (IssueContext)new ProjectContext(projects.iterator().next().getJiraId()));
        return createdCustomField;
    }

    public Either<String, Boolean> makeSureCustomFieldIsApplicableForIssue(CustomField customField, Issue issue, ImporterOptions options) {
        if (customField.isAllIssueTypes()) {
            return Either.right((Object)true);
        }
        if (this.isCustomFieldApplicableForIssue(customField, issue)) {
            return Either.right((Object)true);
        }
        if (this.isCustomFieldLocked(customField)) {
            return Either.left((Object)String.format("Cannot set value for locked custom field '%s' in issue '%s' because it is not applicable for issue type '%s'", customField.getName(), issue.getSummary(), issue.getIssueTypeObject().getName()));
        }
        if (!options.canAlterCustomFieldContext()) {
            return Either.left((Object)"Custom Field is not in scope of issue and context changes are forbidden");
        }
        this.associateCustomFieldWithIssueType(customField, issue);
        return Either.right((Object)true);
    }

    public void addOptions(CustomField customField, Object cfValue, IssueContext context) {
        if (customField == null || !(customField.getCustomFieldType() instanceof MultipleCustomFieldType)) {
            return;
        }
        Collection<Object> values = this.normalizeToCollection(cfValue);
        for (Object value : values) {
            if (value == null) continue;
            if (value instanceof Map) {
                this.handleOptionsInHierarchy(customField, context, (Map)value);
                continue;
            }
            this.createOptionIfDoesNotExist(customField, context, value.toString(), null);
        }
    }

    public boolean clearValueForIssue(CustomField customField, Issue issue) {
        if (customField.canRemoveValueFromIssueObject(issue)) {
            customField.getCustomFieldType().updateValue(customField, issue, null);
            return true;
        }
        return false;
    }

    public boolean isValueEmpty(Object value) {
        Collection<Object> values = this.normalizeToCollection(value);
        if (values.isEmpty()) {
            return true;
        }
        if (values.size() == 1) {
            return this.isNullOrEmptyString(values.iterator().next());
        }
        return false;
    }

    public boolean setCustomFieldValueForIssue(CustomField customField, Object cfValue, MutableIssue issue) {
        Collection<Object> values = this.normalizeToCollection(cfValue);
        Optional<Object> preparedValue = this.customFieldValueFactory.prepareValueForCustomField(customField, (Issue)issue, values);
        if (preparedValue.isPresent()) {
            issue.setCustomFieldValue(customField, preparedValue.get());
            return true;
        }
        customField.createValue((Issue)issue, null);
        return false;
    }

    private void handleOptionsInHierarchy(CustomField customField, IssueContext context, Map map) {
        Object parent;
        Object v = parent = map.get(null) != null ? map.get(null) : map.get("");
        if (parent == null) {
            return;
        }
        Option parentOption = this.createOptionIfDoesNotExist(customField, context, parent.toString(), null);
        Integer level = 1;
        while (parentOption != null && map.get(level.toString()) != null) {
            Object nextLevelOption = map.get(level.toString());
            parentOption = this.createOptionIfDoesNotExist(customField, context, nextLevelOption.toString(), parentOption.getOptionId());
            level = level + 1;
        }
    }

    private Option createOptionIfDoesNotExist(CustomField customField, IssueContext contextNode, String optionValue, Long parentId) {
        FieldConfig config = customField.getRelevantConfig(contextNode);
        Options options = customField.getOptions(null, config, null);
        if (StringUtils.isBlank((String)optionValue) || config == null) {
            return null;
        }
        long sequence = 0L;
        if (options != null) {
            Option option = options.getOptionForValue(optionValue, parentId);
            if (option != null) {
                return option;
            }
            sequence = options.size();
        }
        return this.optionsManager.createOption(config, parentId, Long.valueOf(sequence), optionValue);
    }

    public Collection<Object> normalizeToCollection(Object object) {
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return Lists.newArrayList((Object[])new Object[]{object});
    }

    private boolean isNullOrEmptyString(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }

    private Either<String, Boolean> associateCustomFieldWithIssueType(CustomField customField, Issue issue) {
        List schemes = customField.getConfigurationSchemes();
        if (schemes.isEmpty() || schemes.size() > 1) {
            Either.left((Object)String.format("Custom field '%s' has multiple configuration schemes. Importer is unable to extend custom field context automatically.", customField.getName()));
        }
        FieldConfigScheme scheme = (FieldConfigScheme)Iterables.getOnlyElement((Iterable)schemes);
        HashMap issueTypes = Maps.newHashMap((Map)scheme.getConfigs());
        FieldConfig config = (FieldConfig)Iterables.getFirst((Iterable)scheme.getConfigsByConfig().keySet(), (Object)this.fieldConfigManager.createWithDefaultValues((ConfigurableField)customField));
        if (!issueTypes.containsKey(issue.getIssueTypeObject().getId())) {
            issueTypes.put(issue.getIssueTypeObject().getId(), config);
            FieldConfigScheme configScheme = new FieldConfigScheme.Builder(scheme).setConfigs((Map)issueTypes).toFieldConfigScheme();
            this.fieldConfigSchemeManager.updateFieldConfigScheme(configScheme, Collections.singletonList(GlobalIssueContext.getInstance()), (ConfigurableField)customField);
            this.customFieldManager.refresh();
        }
        return Either.right((Object)true);
    }

    private boolean isCustomFieldApplicableForIssue(CustomField customField, Issue issue) {
        return customField.isInScope(issue.getProjectObject(), (List)ImmutableList.of((Object)issue.getIssueTypeObject().getId()));
    }

    private boolean isCustomFieldLocked(CustomField customField) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(customField);
        if (!item.isManaged()) {
            return false;
        }
        return !this.bridgeUtils.doesUserHavePermission(this.managedConfigurationItemService, this.jiraAuthenticationContext.getUser(), item);
    }

    private void associateCustomFieldWithDefaultScreen(CustomField customField) {
        FieldScreen defaultScreen = this.fieldScreenManager.getFieldScreen(FieldScreen.DEFAULT_SCREEN_ID);
        if (defaultScreen != null && defaultScreen.getTabs() != null && !defaultScreen.getTabs().isEmpty()) {
            FieldScreenTab tab = defaultScreen.getTab(0);
            tab.addFieldScreenLayoutItem(customField.getId());
        }
    }

    @Nullable
    private CustomFieldSearcher getSearcher(ExternalCustomField externalCustomField, CustomFieldType cfType) {
        CustomFieldSearcher fieldSearcher;
        if (StringUtils.isNotEmpty((String)externalCustomField.getSearcherKey()) && (fieldSearcher = this.customFieldManager.getCustomFieldSearcher(externalCustomField.getSearcherKey())) != null) {
            return fieldSearcher;
        }
        List customFieldSearchers = this.customFieldManager.getCustomFieldSearchers(cfType);
        if (customFieldSearchers != null && customFieldSearchers.size() > 0) {
            return (CustomFieldSearcher)customFieldSearchers.iterator().next();
        }
        return null;
    }

    private CustomFieldType getCFType(ExternalCustomField externalCustomField) throws ExternalException {
        CustomFieldType cfType = StringUtils.isEmpty((String)externalCustomField.getTypeKey()) ? this.customFieldManager.getCustomFieldType(DEFAULT_CF_TYPE) : this.customFieldManager.getCustomFieldType(externalCustomField.getTypeKey());
        if (cfType == null) {
            throw new ExternalException(String.format("Cannot create custom field [%s] because its type [%s] is not recognized by this JIRA instance", externalCustomField.getName(), externalCustomField.getTypeKey()));
        }
        return cfType;
    }
}

